/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.datatype.jdk8;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonParser;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonToken;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalLong;

public class OptionalLongDeserializer
extends BaseScalarOptionalDeserializer<OptionalLong> {
    private static final long serialVersionUID = 1L;
    static final OptionalLongDeserializer INSTANCE = new OptionalLongDeserializer();

    public OptionalLongDeserializer() {
        super(OptionalLong.class, OptionalLong.empty());
    }

    @Override
    public OptionalLong deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalLong.of(p.getLongValue());
        }
        switch (p.getCurrentTokenId()) {
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0) {
                    this._coerceEmptyString(ctxt, false);
                    return (OptionalLong)this._empty;
                }
                if (this._hasTextualNull(text)) {
                    this._coerceTextualNull(ctxt, false);
                    return (OptionalLong)this._empty;
                }
                return OptionalLong.of(this._parseLongPrimitive(ctxt, text));
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "long");
                }
                return OptionalLong.of(p.getValueAsLong());
            }
            case 11: {
                return (OptionalLong)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                OptionalLong parsed = this.deserialize(p, ctxt);
                this._verifyEndArrayForSingle(p, ctxt);
                return parsed;
            }
        }
        return (OptionalLong)ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

