/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.config;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.TextParseException;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.config.ResolverConfigProvider;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseResolverConfigProvider
implements ResolverConfigProvider {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    List<InetSocketAddress> nameservers = new ArrayList<InetSocketAddress>(3);
    List<Name> searchlist = new ArrayList<Name>(1);

    BaseResolverConfigProvider() {
    }

    void parseSearchPathList(String search, String delimiter) {
        if (search != null) {
            StringTokenizer st = new StringTokenizer(search, delimiter);
            while (st.hasMoreTokens()) {
                this.addSearchPath(st.nextToken());
            }
        }
    }

    void addSearchPath(String searchPath) {
        if (searchPath == null || searchPath.isEmpty()) {
            return;
        }
        try {
            Name n = Name.fromString(searchPath, Name.root);
            if (!this.searchlist.contains(n)) {
                this.searchlist.add(n);
                this.log.debug("Added {} to search paths", (Object)n);
            }
        }
        catch (TextParseException e) {
            this.log.warn("Could not parse search path {} as a dns name, ignoring", (Object)searchPath);
        }
    }

    void addNameserver(InetSocketAddress server) {
        if (!this.nameservers.contains(server)) {
            this.nameservers.add(server);
            this.log.debug("Added {} to nameservers", (Object)server);
        }
    }

    int parseNdots(String token) {
        if (token != null && !token.isEmpty()) {
            try {
                int ndots = Integer.parseInt(token);
                if (ndots >= 0) {
                    if (ndots > 15) {
                        ndots = 15;
                    }
                    return ndots;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    @Override
    public final List<InetSocketAddress> servers() {
        return Collections.unmodifiableList(this.nameservers);
    }

    @Override
    public final List<Name> searchPaths() {
        return Collections.unmodifiableList(this.searchlist);
    }
}

