/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose;

import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEException;
import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEObject;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSSigner;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import io.hops.hadoop.shaded.com.nimbusds.jose.Payload;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.StandardCharset;
import io.hops.hadoop.shaded.net.jcip.annotations.ThreadSafe;
import java.text.ParseException;

@ThreadSafe
public class JWSObject
extends JOSEObject {
    private static final long serialVersionUID = 1L;
    private final JWSHeader header;
    private final String signingInputString;
    private Base64URL signature;
    private State state;

    public JWSObject(JWSHeader header, Payload payload) {
        if (header == null) {
            throw new IllegalArgumentException("The JWS header must not be null");
        }
        this.header = header;
        if (payload == null) {
            throw new IllegalArgumentException("The payload must not be null");
        }
        this.setPayload(payload);
        this.signingInputString = JWSObject.composeSigningInput(header.toBase64URL(), payload.toBase64URL());
        this.signature = null;
        this.state = State.UNSIGNED;
    }

    public JWSObject(Base64URL firstPart, Base64URL secondPart, Base64URL thirdPart) throws ParseException {
        if (firstPart == null) {
            throw new IllegalArgumentException("The first part must not be null");
        }
        try {
            this.header = JWSHeader.parse(firstPart);
        }
        catch (ParseException e) {
            throw new ParseException("Invalid JWS header: " + e.getMessage(), 0);
        }
        if (secondPart == null) {
            throw new IllegalArgumentException("The second part must not be null");
        }
        this.setPayload(new Payload(secondPart));
        this.signingInputString = JWSObject.composeSigningInput(firstPart, secondPart);
        if (thirdPart == null) {
            throw new IllegalArgumentException("The third part must not be null");
        }
        this.signature = thirdPart;
        this.state = State.SIGNED;
        this.setParsedParts(firstPart, secondPart, thirdPart);
    }

    @Override
    public JWSHeader getHeader() {
        return this.header;
    }

    private static String composeSigningInput(Base64URL firstPart, Base64URL secondPart) {
        return String.valueOf(firstPart.toString()) + '.' + secondPart.toString();
    }

    public byte[] getSigningInput() {
        return this.signingInputString.getBytes(StandardCharset.UTF_8);
    }

    public Base64URL getSignature() {
        return this.signature;
    }

    public State getState() {
        return this.state;
    }

    private void ensureUnsignedState() {
        if (this.state != State.UNSIGNED) {
            throw new IllegalStateException("The JWS object must be in an unsigned state");
        }
    }

    private void ensureSignedOrVerifiedState() {
        if (this.state != State.SIGNED && this.state != State.VERIFIED) {
            throw new IllegalStateException("The JWS object must be in a signed or verified state");
        }
    }

    private void ensureJWSSignerSupport(JWSSigner signer) throws JOSEException {
        if (!signer.supportedJWSAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The \"" + this.getHeader().getAlgorithm() + "\" algorithm is not allowed or supported by the JWS signer: Supported algorithms: " + signer.supportedJWSAlgorithms());
        }
    }

    public synchronized void sign(JWSSigner signer) throws JOSEException {
        this.ensureUnsignedState();
        this.ensureJWSSignerSupport(signer);
        try {
            this.signature = signer.sign(this.getHeader(), this.getSigningInput());
        }
        catch (JOSEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        this.state = State.SIGNED;
    }

    public synchronized boolean verify(JWSVerifier verifier) throws JOSEException {
        boolean verified;
        this.ensureSignedOrVerifiedState();
        try {
            verified = verifier.verify(this.getHeader(), this.getSigningInput(), this.getSignature());
        }
        catch (JOSEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        if (verified) {
            this.state = State.VERIFIED;
        }
        return verified;
    }

    @Override
    public String serialize() {
        this.ensureSignedOrVerifiedState();
        return String.valueOf(this.signingInputString) + '.' + this.signature.toString();
    }

    public static JWSObject parse(String s2) throws ParseException {
        Base64URL[] parts = JOSEObject.split(s2);
        if (parts.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        return new JWSObject(parts[0], parts[1], parts[2]);
    }

    public static /* bridge */ /* synthetic */ JOSEObject parse(String string) throws ParseException {
        return JWSObject.parse(string);
    }

    public static enum State {
        UNSIGNED,
        SIGNED,
        VERIFIED;

    }
}

