/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose.crypto;

import io.hops.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEException;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWECryptoParts;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEEncrypter;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.KeyLengthException;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.ContentCryptoProvider;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.DirectCryptoProvider;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.OctetSequenceKey;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.ByteUtils;
import io.hops.hadoop.shaded.net.jcip.annotations.ThreadSafe;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        JWEAlgorithm alg = header.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        EncryptionMethod enc = header.getEncryptionMethod();
        if (enc.cekBitLength() != ByteUtils.safeBitLength(this.getKey().getEncoded())) {
            throw new KeyLengthException(enc.cekBitLength(), enc);
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

