/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose.crypto;

import io.hops.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEException;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWECryptoParts;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEEncrypter;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.AESKW;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.ContentCryptoProvider;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.PBKDF2;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.PRFParams;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.PasswordBasedCryptoProvider;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.StandardCharset;
import io.hops.hadoop.shaded.net.jcip.annotations.ThreadSafe;
import javax.crypto.SecretKey;

@ThreadSafe
public class PasswordBasedEncrypter
extends PasswordBasedCryptoProvider
implements JWEEncrypter {
    public static final int MIN_SALT_LENGTH = 8;
    private final int saltLength;
    public static final int MIN_RECOMMENDED_ITERATION_COUNT = 1000;
    private final int iterationCount;

    public PasswordBasedEncrypter(byte[] password, int saltLength, int iterationCount) {
        super(password);
        if (saltLength < 8) {
            throw new IllegalArgumentException("The minimum salt length (p2s) is 8 bytes");
        }
        this.saltLength = saltLength;
        if (iterationCount < 1000) {
            throw new IllegalArgumentException("The minimum recommended iteration count (p2c) is 1000");
        }
        this.iterationCount = iterationCount;
    }

    public PasswordBasedEncrypter(String password, int saltLength, int iterationCount) {
        this(password.getBytes(StandardCharset.UTF_8), saltLength, iterationCount);
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        JWEAlgorithm alg = header.getAlgorithm();
        EncryptionMethod enc = header.getEncryptionMethod();
        byte[] salt = new byte[this.saltLength];
        this.getJCAContext().getSecureRandom().nextBytes(salt);
        byte[] formattedSalt = PBKDF2.formatSalt(alg, salt);
        PRFParams prfParams = PRFParams.resolve(alg, this.getJCAContext().getMACProvider());
        SecretKey psKey = PBKDF2.deriveKey(this.getPassword(), formattedSalt, this.iterationCount, prfParams);
        JWEHeader updatedHeader = new JWEHeader.Builder(header).pbes2Salt(Base64URL.encode(salt)).pbes2Count(this.iterationCount).build();
        SecretKey cek = ContentCryptoProvider.generateCEK(enc, this.getJCAContext().getSecureRandom());
        Base64URL encryptedKey = Base64URL.encode(AESKW.wrapCEK(cek, psKey, this.getJCAContext().getKeyEncryptionProvider()));
        return ContentCryptoProvider.encrypt(updatedHeader, clearText, cek, encryptedKey, this.getJCAContext());
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }
}

