/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose.crypto;

import io.hops.hadoop.shaded.com.nimbusds.jose.CriticalHeaderParamsAware;
import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEException;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEDecrypter;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.ContentCryptoProvider;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.CriticalHeaderParamsDeferral;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.RSA1_5;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.RSACryptoProvider;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.RSA_OAEP;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.RSA_OAEP_256;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.RSAKey;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import io.hops.hadoop.shaded.net.jcip.annotations.ThreadSafe;
import java.security.PrivateKey;
import java.util.Set;
import javax.crypto.SecretKey;

@ThreadSafe
public class RSADecrypter
extends RSACryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final PrivateKey privateKey;
    private Exception cekDecryptionException;

    public RSADecrypter(PrivateKey privateKey) {
        this(privateKey, null);
    }

    public RSADecrypter(RSAKey rsaJWK) throws JOSEException {
        if (!rsaJWK.isPrivate()) {
            throw new JOSEException("The RSA JWK doesn't contain a private part");
        }
        this.privateKey = rsaJWK.toPrivateKey();
    }

    public RSADecrypter(PrivateKey privateKey, Set<String> defCritHeaders) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        if (!privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
            throw new IllegalArgumentException("The private key algorithm must be RSA");
        }
        this.privateKey = privateKey;
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        SecretKey cek;
        if (encryptedKey == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        this.critPolicy.ensureHeaderPasses(header);
        JWEAlgorithm alg = header.getAlgorithm();
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            int keyLength = header.getEncryptionMethod().cekBitLength();
            SecretKey randomCEK = ContentCryptoProvider.generateCEK(header.getEncryptionMethod(), this.getJCAContext().getSecureRandom());
            try {
                cek = RSA1_5.decryptCEK(this.privateKey, encryptedKey.decode(), keyLength, this.getJCAContext().getKeyEncryptionProvider());
                if (cek == null) {
                    cek = randomCEK;
                }
            }
            catch (Exception e) {
                this.cekDecryptionException = e;
                cek = randomCEK;
            }
            this.cekDecryptionException = null;
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            cek = RSA_OAEP.decryptCEK(this.privateKey, encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_256)) {
            cek = RSA_OAEP_256.decryptCEK(this.privateKey, encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt(header, encryptedKey, iv, cipherText, authTag, cek, this.getJCAContext());
    }

    public Exception getCEKDecryptionException() {
        return this.cekDecryptionException;
    }
}

