/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose.crypto;

import io.hops.hadoop.shaded.com.nimbusds.jose.CriticalHeaderParamsAware;
import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEException;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.CriticalHeaderParamsDeferral;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.RSASSA;
import io.hops.hadoop.shaded.com.nimbusds.jose.crypto.RSASSAProvider;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.RSAKey;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import io.hops.hadoop.shaded.net.jcip.annotations.ThreadSafe;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;

@ThreadSafe
public class RSASSAVerifier
extends RSASSAProvider
implements JWSVerifier,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final RSAPublicKey publicKey;

    public RSASSAVerifier(RSAPublicKey publicKey) {
        this(publicKey, null);
    }

    public RSASSAVerifier(RSAKey rsaJWK) throws JOSEException {
        this(rsaJWK.toRSAPublicKey(), null);
    }

    public RSASSAVerifier(RSAPublicKey publicKey, Set<String> defCritHeaders) {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public boolean verify(JWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        if (!this.critPolicy.headerPasses(header)) {
            return false;
        }
        Signature verifier = RSASSA.getSignerAndVerifier(header.getAlgorithm(), this.getJCAContext().getProvider());
        try {
            verifier.initVerify(this.publicKey);
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid public RSA key: " + e.getMessage(), e);
        }
        try {
            verifier.update(signedContent);
            return verifier.verify(signature.decode());
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }
}

