/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity;

public class EncodingPolicy {
    private String codec;
    private short targetReplication;

    public EncodingPolicy(String codec, short targetReplication) {
        this.setCodec(codec);
        this.setTargetReplication(targetReplication);
    }

    public void setCodec(String codec) {
        if (codec.length() > 8) {
            throw new IllegalArgumentException("Codec cannot have more than 8 characters");
        }
        this.codec = codec;
    }

    public void setTargetReplication(short targetReplication) {
        this.targetReplication = targetReplication;
    }

    public String getCodec() {
        return this.codec;
    }

    public short getTargetReplication() {
        return this.targetReplication;
    }

    public String toString() {
        return "EncodingPolicy{codec='" + this.codec + '\'' + ", targetReplication=" + this.targetReplication + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingPolicy policy = (EncodingPolicy)o;
        if (this.targetReplication != policy.targetReplication) {
            return false;
        }
        return this.codec.equals(policy.codec);
    }

    public int hashCode() {
        int result = this.codec.hashCode();
        result = 31 * result + this.targetReplication;
        return result;
    }
}

