/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.curator.framework.recipes.nodes;

import io.hops.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.BackgroundPathable;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.CreateModable;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.CuratorEvent;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.CuratorWatcher;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import io.hops.hadoop.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.hops.hadoop.shaded.org.apache.curator.framework.state.ConnectionState;
import io.hops.hadoop.shaded.org.apache.curator.framework.state.ConnectionStateListener;
import io.hops.hadoop.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.hops.hadoop.shaded.org.apache.curator.utils.PathUtils;
import io.hops.hadoop.shaded.org.apache.curator.utils.ThreadUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentNode
implements Closeable {
    private final AtomicReference<CountDownLatch> initialCreateLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final AtomicReference<String> nodePath = new AtomicReference<Object>(null);
    private final String basePath;
    private final CreateMode mode;
    private final AtomicReference<byte[]> data = new AtomicReference();
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicBoolean authFailure = new AtomicBoolean(false);
    private final BackgroundCallback backgroundCallback;
    private final boolean useProtection;
    private final AtomicReference<CreateModable<ACLBackgroundPathAndBytesable<String>>> createMethod = new AtomicReference<Object>(null);
    private final CuratorWatcher watcher = new CuratorWatcher(){

        @Override
        public void process(WatchedEvent event) throws Exception {
            if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                PersistentNode.this.createNode();
            } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                PersistentNode.this.watchNode();
            }
        }
    };
    private final BackgroundCallback checkExistsCallback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                PersistentNode.this.createNode();
            } else {
                boolean isEphemeral;
                boolean bl = isEphemeral = event.getStat().getEphemeralOwner() != 0L;
                if (isEphemeral != PersistentNode.this.mode.isEphemeral()) {
                    PersistentNode.this.log.warn("Existing node ephemeral state doesn't match requested state. Maybe the node was created outside of PersistentNode? " + PersistentNode.this.basePath);
                }
            }
        }
    };
    private final BackgroundCallback setDataCallback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                PersistentNode.this.initialisationComplete();
            }
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED) {
                PersistentNode.this.createNode();
            }
        }
    };

    public PersistentNode(CuratorFramework client, CreateMode mode, boolean useProtection, String basePath, byte[] initData) {
        this.useProtection = useProtection;
        this.client = Preconditions.checkNotNull(client, "client cannot be null");
        this.basePath = PathUtils.validatePath(basePath);
        this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
        byte[] data = Preconditions.checkNotNull(initData, "data cannot be null");
        this.backgroundCallback = new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                if (PersistentNode.this.state.get() == State.STARTED) {
                    PersistentNode.this.processBackgroundCallback(event);
                } else {
                    PersistentNode.this.processBackgroundCallbackClosedState(event);
                }
            }
        };
        this.data.set(Arrays.copyOf(data, data.length));
    }

    private void processBackgroundCallbackClosedState(CuratorEvent event) {
        String path = null;
        if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
            path = event.getPath();
        } else if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
            path = event.getName();
        }
        if (path != null) {
            try {
                ((ErrorListenerPathable)this.client.delete().guaranteed().inBackground()).forPath(path);
            }
            catch (Exception e) {
                this.log.error("Could not delete node after close", (Throwable)e);
            }
        }
    }

    private void processBackgroundCallback(CuratorEvent event) throws Exception {
        String path = null;
        boolean nodeExists = false;
        if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
            path = event.getPath();
            nodeExists = true;
        } else if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
            path = event.getName();
        } else if (event.getResultCode() == KeeperException.Code.NOAUTH.intValue()) {
            this.log.warn("Client does not have authorisation to write node at path {}", (Object)event.getPath());
            this.authFailure.set(true);
            return;
        }
        if (path != null) {
            this.authFailure.set(false);
            this.nodePath.set(path);
            this.watchNode();
            if (nodeExists) {
                ((ErrorListenerPathAndBytesable)this.client.setData().inBackground(this.setDataCallback)).forPath(this.getActualPath(), this.getData());
            } else {
                this.initialisationComplete();
            }
        } else {
            this.createNode();
        }
    }

    private void initialisationComplete() {
        CountDownLatch localLatch = this.initialCreateLatch.getAndSet(null);
        if (localLatch != null) {
            localLatch.countDown();
        }
    }

    public void start() {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Already started");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        this.createNode();
    }

    public boolean waitForInitialCreate(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkState(this.state.get() == State.STARTED, "Not started");
        CountDownLatch localLatch = this.initialCreateLatch.get();
        return localLatch == null || localLatch.await(timeout, unit);
    }

    @Override
    public void close() throws IOException {
        if (!this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            return;
        }
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        try {
            this.deleteNode();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            throw new IOException(e);
        }
    }

    public String getActualPath() {
        return this.nodePath.get();
    }

    public void setData(byte[] data) throws Exception {
        data = Preconditions.checkNotNull(data, "data cannot be null");
        Preconditions.checkState(this.nodePath.get() != null, "initial create has not been processed. Call waitForInitialCreate() to ensure.");
        this.data.set(Arrays.copyOf(data, data.length));
        if (this.isActive()) {
            ((ErrorListenerPathAndBytesable)this.client.setData().inBackground()).forPath(this.getActualPath(), this.getData());
        }
    }

    public byte[] getData() {
        return this.data.get();
    }

    private void deleteNode() throws Exception {
        String localNodePath = this.nodePath.getAndSet(null);
        if (localNodePath != null) {
            try {
                this.client.delete().guaranteed().forPath(localNodePath);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
    }

    private void createNode() {
        if (!this.isActive()) {
            return;
        }
        try {
            CreateModable tempCreateMethod;
            String existingPath = this.nodePath.get();
            String createPath = existingPath != null && !this.useProtection ? existingPath : this.basePath;
            CreateModable localCreateMethod = this.createMethod.get();
            if (localCreateMethod == null && this.createMethod.compareAndSet(null, tempCreateMethod = (CreateModable)((Object)(this.useProtection ? this.client.create().creatingParentContainersIfNeeded().withProtection() : this.client.create().creatingParentContainersIfNeeded())))) {
                localCreateMethod = tempCreateMethod;
            }
            ((ErrorListenerPathAndBytesable)localCreateMethod.withMode(this.getCreateMode(existingPath != null)).inBackground(this.backgroundCallback)).forPath(createPath, this.data.get());
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            throw new RuntimeException("Creating node. BasePath: " + this.basePath, e);
        }
    }

    private CreateMode getCreateMode(boolean pathIsSet) {
        if (pathIsSet) {
            switch (this.mode) {
                default: {
                    break;
                }
                case EPHEMERAL_SEQUENTIAL: {
                    return CreateMode.EPHEMERAL;
                }
                case PERSISTENT_SEQUENTIAL: {
                    return CreateMode.PERSISTENT;
                }
            }
        }
        return this.mode;
    }

    private void watchNode() throws Exception {
        if (!this.isActive()) {
            return;
        }
        String localNodePath = this.nodePath.get();
        if (localNodePath != null) {
            ((ErrorListenerPathable)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).inBackground(this.checkExistsCallback)).forPath(localNodePath);
        }
    }

    private boolean isActive() {
        return this.state.get() == State.STARTED;
    }

    @VisibleForTesting
    boolean isAuthFailure() {
        return this.authFailure.get();
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

