/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.response;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.request.ApRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApRep;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.EncAPRepPart;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;

public class ApResponse {
    private ApReq apReq;
    private ApRep apRep;
    EncryptionKey encryptionKey;

    public ApResponse(ApReq apReq, EncryptionKey encryptionKey) {
        this.apReq = apReq;
        this.encryptionKey = encryptionKey;
    }

    public ApRep getApRep() throws KrbException {
        ApRequest.validate(this.encryptionKey, this.apReq);
        if (this.apRep == null) {
            this.apRep = this.makeApRep();
        }
        return this.apRep;
    }

    public void setApRep(ApRep apRep) {
        this.apRep = apRep;
    }

    private ApRep makeApRep() throws KrbException {
        ApRep apRep = new ApRep();
        EncAPRepPart encAPRepPart = new EncAPRepPart();
        encAPRepPart.setCtime(KerberosTime.now());
        encAPRepPart.setCusec((int)KerberosTime.now().getTimeInSeconds());
        encAPRepPart.setSubkey(this.apReq.getAuthenticator().getSubKey());
        encAPRepPart.setSeqNumber(0);
        apRep.setEncRepPart(encAPRepPart);
        EncryptedData encPart = EncryptionUtil.seal(encAPRepPart, this.apReq.getAuthenticator().getSubKey(), KeyUsage.AP_REP_ENCPART);
        apRep.setEncryptedEncPart(encPart);
        return apRep;
    }
}

