/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.tukaani.xz.lz;

import io.hops.hadoop.shaded.org.tukaani.xz.CorruptedInputException;
import java.io.DataInputStream;
import java.io.IOException;

public final class LZDecoder {
    private byte[] buf;
    private int start = 0;
    private int pos = 0;
    private int full = 0;
    private int limit = 0;
    private int pendingLen = 0;
    private int pendingDist = 0;

    public LZDecoder(int n, byte[] byArray) {
        this.buf = new byte[n];
        if (byArray != null) {
            this.full = this.pos = Math.min(byArray.length, n);
            this.start = this.pos;
            System.arraycopy(byArray, byArray.length - this.pos, this.buf, 0, this.pos);
        }
    }

    public void reset() {
        this.start = 0;
        this.pos = 0;
        this.full = 0;
        this.limit = 0;
        this.buf[this.buf.length - 1] = 0;
    }

    public void setLimit(int n) {
        this.limit = this.buf.length - this.pos <= n ? this.buf.length : this.pos + n;
    }

    public boolean hasSpace() {
        return this.pos < this.limit;
    }

    public boolean hasPending() {
        return this.pendingLen > 0;
    }

    public int getPos() {
        return this.pos;
    }

    public int getByte(int n) {
        int n2 = this.pos - n - 1;
        if (n >= this.pos) {
            n2 += this.buf.length;
        }
        return this.buf[n2] & 0xFF;
    }

    public void putByte(byte by) {
        this.buf[this.pos++] = by;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeat(int n, int n2) throws IOException {
        if (n < 0 || n >= this.full) {
            throw new CorruptedInputException();
        }
        int n3 = Math.min(this.limit - this.pos, n2);
        this.pendingLen = n2 - n3;
        this.pendingDist = n;
        int n4 = this.pos - n - 1;
        if (n >= this.pos) {
            n4 += this.buf.length;
        }
        do {
            this.buf[this.pos++] = this.buf[n4++];
            if (n4 != this.buf.length) continue;
            n4 = 0;
        } while (--n3 > 0);
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeatPending() throws IOException {
        if (this.pendingLen > 0) {
            this.repeat(this.pendingDist, this.pendingLen);
        }
    }

    public void copyUncompressed(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = Math.min(this.buf.length - this.pos, n);
        dataInputStream.readFully(this.buf, this.pos, n2);
        this.pos += n2;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public int flush(byte[] byArray, int n) {
        int n2 = this.pos - this.start;
        if (this.pos == this.buf.length) {
            this.pos = 0;
        }
        System.arraycopy(this.buf, this.start, byArray, n, n2);
        this.start = this.pos;
        return n2;
    }
}

