/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.util;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.Sets;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.ConsulException;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.async.ConsulResponseCallback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.ConsulResponse;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.monitoring.ClientEventHandler;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.okhttp3.Headers;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.apache.commons.lang3.math.NumberUtils;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.Call;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.Callback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.Response;
import java.io.IOException;
import java.math.BigInteger;

public class Http {
    private final ClientEventHandler eventHandler;

    public Http(ClientEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    private static boolean isSuccessful(Response<?> response, Integer ... okCodes) {
        return response.isSuccessful() || Sets.newHashSet(okCodes).contains(response.code());
    }

    public <T> T extract(Call<T> call, Integer ... okCodes) {
        Response<T> response = this.executeCall(call);
        this.ensureResponseSuccessful(call, response, okCodes);
        return response.body();
    }

    public void handle(Call<Void> call, Integer ... okCodes) {
        Response<Void> response = this.executeCall(call);
        this.ensureResponseSuccessful(call, response, okCodes);
    }

    public <T> ConsulResponse<T> extractConsulResponse(Call<T> call, Integer ... okCodes) {
        Response<T> response = this.executeCall(call);
        this.ensureResponseSuccessful(call, response, okCodes);
        return Http.consulResponse(response);
    }

    private <T> Response<T> executeCall(Call<T> call) {
        try {
            return call.execute();
        }
        catch (IOException e) {
            this.eventHandler.httpRequestFailure(call.request(), e);
            throw new ConsulException(e);
        }
    }

    private <T> void ensureResponseSuccessful(Call<T> call, Response<T> response, Integer ... okCodes) {
        if (!Http.isSuccessful(response, okCodes)) {
            ConsulException exception = new ConsulException(response.code(), response);
            this.eventHandler.httpRequestInvalid(call.request(), exception);
            throw exception;
        }
        this.eventHandler.httpRequestSuccess(call.request());
    }

    public <T> void extractConsulResponse(Call<T> call, ConsulResponseCallback<T> callback, Integer ... okCodes) {
        call.enqueue(this.createCallback(call, callback, okCodes));
    }

    @VisibleForTesting
    <T> Callback<T> createCallback(Call<T> call, final ConsulResponseCallback<T> callback, final Integer ... okCodes) {
        return new Callback<T>(){

            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                if (Http.isSuccessful(response, okCodes)) {
                    Http.this.eventHandler.httpRequestSuccess(call.request());
                    callback.onComplete(Http.consulResponse(response));
                } else {
                    ConsulException exception = new ConsulException(response.code(), response);
                    Http.this.eventHandler.httpRequestInvalid(call.request(), exception);
                    callback.onFailure(exception);
                }
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                Http.this.eventHandler.httpRequestFailure(call.request(), t);
                callback.onFailure(t);
            }
        };
    }

    public <T> void extractBasicResponse(Call<T> call, io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.async.Callback<T> callback, Integer ... okCodes) {
        this.extractConsulResponse(call, this.createConsulResponseCallbackWrapper(callback), okCodes);
    }

    private <T> ConsulResponseCallback<T> createConsulResponseCallbackWrapper(final io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.async.Callback<T> callback) {
        return new ConsulResponseCallback<T>(){

            @Override
            public void onComplete(ConsulResponse<T> consulResponse) {
                callback.onResponse(consulResponse.getResponse());
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
    }

    @VisibleForTesting
    static <T> ConsulResponse<T> consulResponse(Response<T> response) {
        Headers headers = response.headers();
        String indexHeaderValue = headers.get("X-Consul-Index");
        String lastContactHeaderValue = headers.get("X-Consul-Lastcontact");
        String knownLeaderHeaderValue = headers.get("X-Consul-Knownleader");
        BigInteger index = indexHeaderValue == null ? BigInteger.ZERO : new BigInteger(indexHeaderValue);
        long lastContact = lastContactHeaderValue == null ? 0L : NumberUtils.toLong(lastContactHeaderValue);
        boolean knownLeader = knownLeaderHeaderValue == null ? false : Boolean.valueOf(knownLeaderHeaderValue);
        return new ConsulResponse<T>(response.body(), lastContact, knownLeader, index, headers.get("X-Cache"), headers.get("Age"));
    }
}

