/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.transaction.lock;

import io.hops.hadoop.shaded.io.hops.exception.StorageException;
import io.hops.hadoop.shaded.io.hops.exception.TransactionContextException;
import io.hops.hadoop.shaded.io.hops.metadata.common.FinderType;
import io.hops.hadoop.shaded.io.hops.transaction.EntityManager;
import io.hops.hadoop.shaded.io.hops.transaction.lock.TransactionLockTypes;
import io.hops.hadoop.shaded.io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Lock
implements Comparable<Lock> {
    protected static final Log LOG = LogFactory.getLog(Lock.class);
    protected static final TransactionLockTypes.LockType DEFAULT_LOCK_TYPE = TransactionLockTypes.LockType.READ_COMMITTED;

    protected Lock() {
    }

    protected abstract void acquire(TransactionLocks var1) throws IOException;

    protected abstract Type getType();

    @Override
    public int compareTo(Lock o) {
        return this.getType().compareTo(o.getType());
    }

    protected static void setLockMode(TransactionLockTypes.LockType mode) throws StorageException {
        switch (mode) {
            case WRITE: {
                EntityManager.writeLock();
                break;
            }
            case READ: {
                EntityManager.readLock();
                break;
            }
            case READ_COMMITTED: {
                EntityManager.readCommited();
            }
        }
    }

    protected <T> Collection<T> acquireLockList(TransactionLockTypes.LockType lock, FinderType<T> finder, Object ... param) throws StorageException, TransactionContextException {
        Lock.setLockMode(lock);
        if (param == null) {
            return EntityManager.findList(finder, new Object[0]);
        }
        return EntityManager.findList(finder, param);
    }

    protected <T> T acquireLock(TransactionLockTypes.LockType lock, FinderType<T> finder, Object ... param) throws StorageException, TransactionContextException {
        Lock.setLockMode(lock);
        if (param == null) {
            return null;
        }
        return EntityManager.find(finder, param);
    }

    public static enum Type {
        INode,
        NameNodeLease,
        Lease,
        LeasePath,
        AllCachedBlock,
        Block,
        Variable,
        LeDescriptor,
        Replica,
        CorruptReplica,
        ExcessReplica,
        ReplicaUnderConstruction,
        InvalidatedBlock,
        UnderReplicatedBlock,
        PendingBlock,
        QuotaUpdate,
        EncodingStatus,
        BlockChecksum,
        SubTreePath,
        Test,
        HashBucket,
        Ace,
        retryCachEntry,
        cacheDirective,
        cachePool,
        CachedBlock,
        XAttr,
        EZ;

    }
}

