/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.net.ntp;

import io.hops.hadoop.shaded.org.apache.commons.net.ntp.NtpV3Packet;
import io.hops.hadoop.shaded.org.apache.commons.net.ntp.TimeStamp;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class TimeInfo {
    private final NtpV3Packet message;
    private List<String> comments;
    private Long delayMillis;
    private Long offsetMillis;
    private final long returnTimeMillis;
    private boolean detailsComputed;

    public TimeInfo(NtpV3Packet message, long returnTimeMillis) {
        this(message, returnTimeMillis, null, true);
    }

    public TimeInfo(NtpV3Packet msgPacket, long returnTimeMillis, boolean doComputeDetails) {
        this(msgPacket, returnTimeMillis, null, doComputeDetails);
    }

    public TimeInfo(NtpV3Packet message, long returnTimeMillis, List<String> comments) {
        this(message, returnTimeMillis, comments, true);
    }

    public TimeInfo(NtpV3Packet message, long returnTimeMillis, List<String> comments, boolean doComputeDetails) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this.returnTimeMillis = returnTimeMillis;
        this.message = message;
        this.comments = comments;
        if (doComputeDetails) {
            this.computeDetails();
        }
    }

    public void addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(comment);
    }

    public void computeDetails() {
        if (this.detailsComputed) {
            return;
        }
        this.detailsComputed = true;
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        TimeStamp origNtpTime = this.message.getOriginateTimeStamp();
        long origTimeMillis = origNtpTime.getTime();
        TimeStamp rcvNtpTime = this.message.getReceiveTimeStamp();
        long rcvTimeMillis = rcvNtpTime.getTime();
        TimeStamp xmitNtpTime = this.message.getTransmitTimeStamp();
        long xmitTimeMillis = xmitNtpTime.getTime();
        if (origNtpTime.ntpValue() == 0L) {
            if (xmitNtpTime.ntpValue() != 0L) {
                this.offsetMillis = xmitTimeMillis - this.returnTimeMillis;
                this.comments.add("Error: zero orig time -- cannot compute delay");
            } else {
                this.comments.add("Error: zero orig time -- cannot compute delay/offset");
            }
        } else if (rcvNtpTime.ntpValue() == 0L || xmitNtpTime.ntpValue() == 0L) {
            this.comments.add("Warning: zero rcvNtpTime or xmitNtpTime");
            if (origTimeMillis > this.returnTimeMillis) {
                this.comments.add("Error: OrigTime > DestRcvTime");
            } else {
                this.delayMillis = this.returnTimeMillis - origTimeMillis;
            }
            if (rcvNtpTime.ntpValue() != 0L) {
                this.offsetMillis = rcvTimeMillis - origTimeMillis;
            } else if (xmitNtpTime.ntpValue() != 0L) {
                this.offsetMillis = xmitTimeMillis - this.returnTimeMillis;
            }
        } else {
            long delayValueMillis = this.returnTimeMillis - origTimeMillis;
            if (xmitTimeMillis < rcvTimeMillis) {
                this.comments.add("Error: xmitTime < rcvTime");
            } else {
                long deltaMillis = xmitTimeMillis - rcvTimeMillis;
                if (deltaMillis <= delayValueMillis) {
                    delayValueMillis -= deltaMillis;
                } else if (deltaMillis - delayValueMillis == 1L) {
                    if (delayValueMillis != 0L) {
                        this.comments.add("Info: processing time > total network time by 1 ms -> assume zero delay");
                        delayValueMillis = 0L;
                    }
                } else {
                    this.comments.add("Warning: processing time > total network time");
                }
            }
            this.delayMillis = delayValueMillis;
            if (origTimeMillis > this.returnTimeMillis) {
                this.comments.add("Error: OrigTime > DestRcvTime");
            }
            this.offsetMillis = (rcvTimeMillis - origTimeMillis + (xmitTimeMillis - this.returnTimeMillis)) / 2L;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInfo other = (TimeInfo)obj;
        return this.returnTimeMillis == other.returnTimeMillis && this.message.equals(other.message);
    }

    public InetAddress getAddress() {
        DatagramPacket pkt = this.message.getDatagramPacket();
        return pkt == null ? null : pkt.getAddress();
    }

    public List<String> getComments() {
        return this.comments;
    }

    public Long getDelay() {
        return this.delayMillis;
    }

    public NtpV3Packet getMessage() {
        return this.message;
    }

    public Long getOffset() {
        return this.offsetMillis;
    }

    public long getReturnTime() {
        return this.returnTimeMillis;
    }

    public int hashCode() {
        int prime = 31;
        int result = (int)this.returnTimeMillis;
        result = 31 * result + this.message.hashCode();
        return result;
    }
}

