/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base;

import io.hops.hadoop.shaded.org.apache.kerby.asn1.Asn1FieldInfo;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.EnumType;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.ExplicitField;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Integer;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.type.Asn1OctetString;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddrType;
import java.net.InetAddress;
import java.util.Arrays;

public class HostAddress
extends KrbSequenceType {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(HostAddressField.ADDR_TYPE, Asn1Integer.class), new ExplicitField(HostAddressField.ADDRESS, Asn1OctetString.class)};

    public HostAddress() {
        super(fieldInfos);
    }

    public HostAddress(InetAddress inetAddress) {
        super(fieldInfos);
        this.setAddrType(HostAddrType.ADDRTYPE_INET);
        this.setAddress(inetAddress.getAddress());
    }

    public HostAddrType getAddrType() {
        Integer value = this.getFieldAsInteger(HostAddressField.ADDR_TYPE);
        return HostAddrType.fromValue(value);
    }

    public void setAddrType(HostAddrType addrType) {
        this.setField(HostAddressField.ADDR_TYPE, addrType);
    }

    public byte[] getAddress() {
        return this.getFieldAsOctets(HostAddressField.ADDRESS);
    }

    public void setAddress(byte[] address) {
        this.setFieldAsOctets(HostAddressField.ADDRESS, address);
    }

    public boolean equalsWith(InetAddress address) {
        if (address == null) {
            return false;
        }
        HostAddress that = new HostAddress(address);
        return this.equals(that);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HostAddress)) {
            return false;
        }
        HostAddress that = (HostAddress)other;
        return this.getAddrType() == that.getAddrType() && Arrays.equals(this.getAddress(), that.getAddress());
    }

    public int hashCode() {
        int hash = 17 + this.getAddrType().getValue() * 31;
        if (this.getAddress() != null) {
            hash = 31 * hash + Arrays.hashCode(this.getAddress());
        }
        return hash;
    }

    protected static enum HostAddressField implements EnumType
    {
        ADDR_TYPE,
        ADDRESS;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

