/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.cdi;

import io.hops.hadoop.shaded.com.sun.jersey.api.core.ResourceConfig;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentContext;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentScope;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ioc.IoCDestroyable;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ioc.IoCFullyManagedComponentProvider;
import io.hops.hadoop.shaded.com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.cdi.CDIExtension;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.cdi.Utils;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.WebApplication;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.WebApplicationListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class CDIComponentProviderFactory
implements IoCComponentProviderFactory,
WebApplicationListener {
    private static final Logger LOGGER = Logger.getLogger(CDIComponentProviderFactory.class.getName());
    private final BeanManager beanManager;
    private final CDIExtension extension;
    private final Map<Class<? extends Annotation>, ComponentScope> scopeMap = this.createScopeMap();

    public CDIComponentProviderFactory(Object bm, ResourceConfig rc, WebApplication wa) {
        this.beanManager = (BeanManager)bm;
        this.extension = CDIExtension.lookupExtensionInBeanManager ? CDIExtension.getInitializedExtensionFromBeanManager(this.beanManager) : CDIExtension.getInitializedExtension();
        this.extension.setWebApplication(wa);
        this.extension.setResourceConfig(rc);
    }

    public void onWebApplicationReady() {
        this.extension.lateInitialize();
    }

    @Override
    public IoCComponentProvider getComponentProvider(Class<?> c) {
        return this.getComponentProvider(null, c);
    }

    @Override
    public IoCComponentProvider getComponentProvider(ComponentContext cc, final Class<?> c) {
        final Bean<?> b = Utils.getBean(this.beanManager, c);
        if (b == null) {
            return null;
        }
        Class s2 = b.getScope();
        final ComponentScope cs = this.getComponentScope(b);
        if (s2 == Dependent.class) {
            if (!this.extension.getResourceConfig().getFeature("io.hops.hadoop.shaded.com.sun.jersey.config.feature.AllowRawManagedBeans") && !c.isAnnotationPresent(ManagedBean.class)) {
                return null;
            }
            LOGGER.fine("Binding the CDI managed bean " + c.getName() + " in scope " + s2.getName() + " to CDIComponentProviderFactory");
            return new ComponentProviderDestroyable(){

                @Override
                public Object getInjectableInstance(Object o) {
                    return o;
                }

                @Override
                public Object getInstance() {
                    CreationalContext bcc = CDIComponentProviderFactory.this.beanManager.createCreationalContext((Contextual)b);
                    return c.cast(CDIComponentProviderFactory.this.beanManager.getReference(b, (Type)c, bcc));
                }

                @Override
                public void destroy(Object o) {
                    CreationalContext cc = CDIComponentProviderFactory.this.beanManager.createCreationalContext((Contextual)b);
                    b.destroy(o, cc);
                }
            };
        }
        LOGGER.fine("Binding the CDI managed bean " + c.getName() + " in scope " + s2.getName() + " to CDIComponentProviderFactory in scope " + (Object)((Object)cs));
        return new IoCFullyManagedComponentProvider(){

            @Override
            public ComponentScope getScope() {
                return cs;
            }

            @Override
            public Object getInstance() {
                CreationalContext bcc = CDIComponentProviderFactory.this.beanManager.createCreationalContext((Contextual)b);
                return c.cast(CDIComponentProviderFactory.this.beanManager.getReference(b, (Type)c, bcc));
            }
        };
    }

    private ComponentScope getComponentScope(Bean<?> b) {
        ComponentScope cs = this.scopeMap.get(b.getScope());
        return cs != null ? cs : ComponentScope.Undefined;
    }

    private Map<Class<? extends Annotation>, ComponentScope> createScopeMap() {
        HashMap<Class<Dependent>, ComponentScope> m3 = new HashMap<Class<Dependent>, ComponentScope>();
        m3.put(ApplicationScoped.class, ComponentScope.Singleton);
        m3.put(RequestScoped.class, ComponentScope.PerRequest);
        m3.put(Dependent.class, ComponentScope.PerRequest);
        return Collections.unmodifiableMap(m3);
    }

    private static interface ComponentProviderDestroyable
    extends IoCInstantiatedComponentProvider,
    IoCDestroyable {
    }
}

