/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.common.entity;

import io.hops.hadoop.shaded.io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.DoubleVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.IntVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.LongVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.StringVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.Variable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ArrayVariable
extends Variable {
    private List<Variable> vars = new ArrayList<Variable>();
    private int length = 0;

    public ArrayVariable(Variable.Finder type) {
        super(type);
    }

    public ArrayVariable(Variable.Finder type, List<? extends Object> value) {
        this(type);
        this.initVariables(value);
    }

    public ArrayVariable(List<? extends Object> value) {
        this(Variable.Finder.GenericArray, value);
    }

    public void addVariable(Variable var) {
        this.length += var.getLength();
        this.vars.add(var);
    }

    @Override
    public List<Variable> getValue() {
        return this.vars;
    }

    public List<? extends Object> getVarsValue() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Variable var : this.vars) {
            vals.add(var.getValue());
        }
        return vals;
    }

    @Override
    public void setValue(byte[] val) {
        if (val == null || val.length == 0) {
            return;
        }
        ByteBuffer varsData = ByteBuffer.wrap(val);
        while (varsData.hasRemaining()) {
            byte[] vdata;
            Variable var = ArrayVariable.getVariable(varsData.get());
            int off = 0;
            int len = var.getLength();
            if (var instanceof StringVariable || var instanceof ByteArrayVariable) {
                len = varsData.get();
                off = 1;
                vdata = new byte[len + off];
                vdata[0] = (byte)len;
            } else {
                vdata = new byte[len];
            }
            varsData.get(vdata, off, len);
            var.setValue(vdata);
            this.vars.add(var);
        }
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer varsData = ByteBuffer.allocate(this.getLength());
        for (Variable var : this.vars) {
            varsData.put((byte)var.getType().getId());
            varsData.put(var.getBytes());
        }
        return varsData.array();
    }

    @Override
    public int getLength() {
        return this.length + this.vars.size();
    }

    private void initVariables(List<? extends Object> arrItems) {
        for (Object object : arrItems) {
            Class<?> itemClass = object.getClass();
            if (itemClass == Integer.class) {
                this.addVariable(new IntVariable((Integer)object));
                continue;
            }
            if (itemClass == Long.class) {
                this.addVariable(new LongVariable((Long)object));
                continue;
            }
            if (itemClass == String.class) {
                this.addVariable(new StringVariable((String)object));
                continue;
            }
            if (itemClass == Double.class) {
                this.addVariable(new DoubleVariable((Double)object));
                continue;
            }
            if (object instanceof byte[]) {
                this.addVariable(new ByteArrayVariable((byte[])object));
                continue;
            }
            throw new IllegalArgumentException("Variable Type " + itemClass + " is not supported");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayVariable that = (ArrayVariable)o;
        if (this.vars.size() != that.vars.size()) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        for (int i = 0; i < this.vars.size(); ++i) {
            Variable v2;
            Variable v1 = this.vars.get(i);
            if (v1.equals(v2 = that.vars.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.vars, this.length);
    }
}

