/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity;

import io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity.StoredXAttr;

public class FileProvenanceEntry {
    private final long inodeId;
    private final Operation operation;
    private final int logicalTime;
    private final long timestamp;
    private final String appId;
    private final int userId;
    private final String tieBreaker;
    private final long partitionId;
    private final long projectId;
    private final long datasetId;
    private final long parentId;
    private final String inodeName;
    private final String projectName;
    private final String datasetName;
    private final String p1Name;
    private final String p2Name;
    private final String parentName;
    private final String userName;
    private final String xattrName;
    private final int logicalTimeBatch;
    private final long timestampBatch;
    private final int dsLogicalTime;
    private final short xattrNumParts;

    public FileProvenanceEntry(long inodeId, Operation operation, int logicalTime, long timestamp, String appId, int userId, String tieBreaker, long partitionId, long projectId, long datasetId, long parentId, String inodeName, String projectName, String datasetName, String p1Name, String p2Name, String parentName, String userName, String xattrName, int logicalTimeBatch, long timestampBatch, int dsLogicalTime, byte[] xAttrValue) {
        this.inodeId = inodeId;
        this.operation = operation;
        this.logicalTime = logicalTime;
        this.timestamp = timestamp;
        this.appId = appId;
        this.userId = userId;
        this.tieBreaker = tieBreaker;
        this.partitionId = partitionId;
        this.projectId = projectId;
        this.datasetId = datasetId;
        this.parentId = parentId;
        this.inodeName = inodeName;
        this.projectName = projectName;
        this.datasetName = datasetName;
        this.p1Name = p1Name;
        this.p2Name = p2Name;
        this.parentName = parentName;
        this.userName = userName;
        this.xattrName = xattrName;
        this.logicalTimeBatch = logicalTimeBatch;
        this.timestampBatch = timestampBatch;
        this.dsLogicalTime = dsLogicalTime;
        this.xattrNumParts = StoredXAttr.getNumParts(xAttrValue);
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getTieBreaker() {
        return this.tieBreaker;
    }

    public int getLogicalTime() {
        return this.logicalTime;
    }

    public int getLogicalTimeBatch() {
        return this.logicalTimeBatch;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTimestampBatch() {
        return this.timestampBatch;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public long getDatasetId() {
        return this.datasetId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getInodeName() {
        return this.inodeName;
    }

    public Operation getOperationEnumVal() {
        return this.operation;
    }

    public String getOperation() {
        return this.operation.toString();
    }

    public String getP1Name() {
        return this.p1Name;
    }

    public String getP2Name() {
        return this.p2Name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getXattrName() {
        return this.xattrName;
    }

    public int getDsLogicalTime() {
        return this.dsLogicalTime;
    }

    public short getXattrNumParts() {
        return this.xattrNumParts;
    }

    public String toString() {
        return "ProvenanceLogEntry{inodeId=" + this.inodeId + ", operation=" + (Object)((Object)this.operation) + ", logicalTime=" + this.logicalTime + ", timestamp=" + this.timestamp + ", appId=" + this.appId + ", userId=" + this.userId + ", tieBreaker=" + this.tieBreaker + ", partitionId=" + this.partitionId + ", projectId=" + this.projectId + ", datasetId=" + this.datasetId + ", parentId=" + this.parentId + ", inodeName=" + this.inodeName + ", projectName=" + this.projectName + ", datasetName=" + this.datasetName + ", p1Name=" + this.p1Name + ", p2Name=" + this.p2Name + ", parentName=" + this.parentName + ", userName=" + this.userName + ", xattrName=" + this.xattrName + ", logicalTimeBatch=" + this.logicalTimeBatch + ", timestampBatch=" + this.timestampBatch + ", dsLogicalTime=" + this.dsLogicalTime + '}';
    }

    public static enum Operation {
        CREATE,
        DELETE,
        ACCESS_DATA,
        MODIFY_DATA,
        METADATA,
        XATTR_ADD,
        XATTR_UPDATE,
        XATTR_DELETE,
        OTHER;


        public static Operation create() {
            return CREATE;
        }

        public static Operation delete() {
            return DELETE;
        }

        public static Operation getBlockLocations() {
            return ACCESS_DATA;
        }

        public static Operation append() {
            return MODIFY_DATA;
        }

        public static Operation concat() {
            return OTHER;
        }

        public static Operation createSymlink() {
            return OTHER;
        }

        public static Operation setPermission() {
            return METADATA;
        }

        public static Operation setOwner() {
            return METADATA;
        }

        public static Operation setTimes() {
            return OTHER;
        }

        public static Operation setReplication() {
            return OTHER;
        }

        public static Operation setMetaEnabled() {
            return OTHER;
        }

        public static Operation setStoragePolicy() {
            return OTHER;
        }

        public static Operation getfileinfo() {
            return OTHER;
        }

        public static Operation listStatus() {
            return OTHER;
        }

        public static Operation addXAttr() {
            return XATTR_ADD;
        }
    }
}

