/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.transaction.context;

import io.hops.hadoop.shaded.io.hops.metadata.common.FinderType;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public class EntityContextStat {
    static final int CONTEXT_INDENTATION = 2;
    static final int OPERATION_INDENTATION = 5;
    static final int CONTEXT_STAT_INDENTATION = 3;
    static final int NUMBER_WIDTH = 4;
    static final String NEW_LINE = "\n";
    private final String contextName;
    private final Map<FinderType, HitMissCounter> operationsStats;
    private StatsAggregator statsAggregator;

    public EntityContextStat(String contextName) {
        this.contextName = contextName;
        this.operationsStats = new HashMap<FinderType, HitMissCounter>();
        this.statsAggregator = new StatsAggregator();
    }

    public void hit(FinderType finder, int count) {
        this.getCounter(finder).hit(count);
        this.statsAggregator.hit(finder, count);
    }

    public void miss(FinderType finder, int count) {
        this.getCounter(finder).miss(count);
        this.statsAggregator.miss(finder, count);
    }

    private HitMissCounter getCounter(FinderType finder) {
        HitMissCounter counter = this.operationsStats.get(finder);
        if (counter == null) {
            counter = new HitMissCounter();
            this.operationsStats.put(finder, counter);
        }
        return counter;
    }

    public void commited(int newRows, int modifiedRows, int deletedRows) {
        this.statsAggregator.update(newRows, modifiedRows, deletedRows);
    }

    public String getContextName() {
        return this.contextName;
    }

    boolean isEmpty() {
        return this.statsAggregator.isEmpty() && this.operationsStats.isEmpty();
    }

    StatsAggregator getStatsAggregator() {
        return this.statsAggregator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EntityContextStat.getCF("----------------------------------------", new Object[0]));
        sb.append(EntityContextStat.getCF(this.contextName, new Object[0]));
        for (Map.Entry<FinderType, HitMissCounter> e : this.operationsStats.entrySet()) {
            sb.append(EntityContextStat.getOPF("%s[%s] H=%-4d M=%-4d", e.getKey(), e.getKey().getAnnotated().getShort(), e.getValue().hits, e.getValue().misses));
        }
        sb.append(EntityContextStat.getCSF(this.statsAggregator.getRowStats(), new Object[0]));
        sb.append(EntityContextStat.getCSF(this.statsAggregator.getHitsMisses(), new Object[0]));
        String detailedMisses = this.statsAggregator.getDetailedMisses();
        if (!detailedMisses.isEmpty()) {
            sb.append(EntityContextStat.getCSF(detailedMisses, new Object[0]));
        }
        sb.append(EntityContextStat.getCF("----------------------------------------", new Object[0]));
        return sb.toString();
    }

    static String getOPF(String format, Object ... params) {
        return String.format(EntityContextStat.getStringSpacing(5) + format + NEW_LINE, EntityContextStat.prefix("", params));
    }

    static String getCSF(String format, Object ... params) {
        return String.format(EntityContextStat.getStringSpacing(3) + format + NEW_LINE, EntityContextStat.prefix("", params));
    }

    static String getCF(String format, Object ... params) {
        return String.format(EntityContextStat.getStringSpacing(2) + format + NEW_LINE, EntityContextStat.prefix("", params));
    }

    private static Object[] prefix(Object p, Object[] params) {
        Object[] res = new Object[params.length + 1];
        res[0] = p;
        System.arraycopy(params, 0, res, 1, params.length);
        return res;
    }

    private static String getStringSpacing(int spaces) {
        return "%" + spaces + "s ";
    }

    static class HitMissCounter {
        int hits;
        int hitsRowsCount;
        int misses;
        int missesRowsCount;

        HitMissCounter() {
        }

        void hit(int hitsRowsCount) {
            this.hit(1, hitsRowsCount);
        }

        void miss(int missesRowsCount) {
            this.miss(1, missesRowsCount);
        }

        void hit(int hits, int hitsRowsCount) {
            this.hits += hits;
            this.hitsRowsCount += hitsRowsCount;
        }

        void miss(int misses, int missesRowsCount) {
            this.misses += misses;
            this.missesRowsCount += missesRowsCount;
        }

        void update(HitMissCounter other) {
            this.hit(other.hits, other.hitsRowsCount);
            this.miss(other.misses, other.missesRowsCount);
        }

        String onlyMisses() {
            if (this.misses == 0) {
                return "";
            }
            return String.format("%d(%d)", this.misses, this.missesRowsCount);
        }

        public String toString() {
            if (this.hits == 0 && this.misses == 0) {
                return "";
            }
            return String.format("Hits=%d(%d) Misses=%d(%d)" + (this.misses > this.hits ? " MORE DATA THAN NEEDED" : ""), this.hits, this.hitsRowsCount, this.misses, this.missesRowsCount);
        }
    }

    static class StatsAggregator {
        HitMissCounter hitMissCounter = new HitMissCounter();
        int newRows = 0;
        int modifiedRows = 0;
        int deletedRows = 0;
        private EnumMap<FinderType.Annotation, HitMissCounter> annotated = new EnumMap(FinderType.Annotation.class);

        StatsAggregator() {
        }

        void hit(FinderType finderType, int hitRowsCount) {
            this.getCounter(finderType.getAnnotated()).hit(hitRowsCount);
            this.hitMissCounter.hit(hitRowsCount);
        }

        void miss(FinderType finderType, int missRowsCount) {
            this.getCounter(finderType.getAnnotated()).miss(missRowsCount);
            this.hitMissCounter.miss(missRowsCount);
        }

        HitMissCounter getCounter(FinderType.Annotation annotation) {
            HitMissCounter counter = this.annotated.get((Object)annotation);
            if (counter == null) {
                counter = new HitMissCounter();
                this.annotated.put(annotation, counter);
            }
            return counter;
        }

        void update(int newRows, int modifiedRows, int deletedRows) {
            this.newRows += newRows;
            this.modifiedRows += modifiedRows;
            this.deletedRows += deletedRows;
        }

        void update(StatsAggregator statsAggregator) {
            this.update(statsAggregator.newRows, statsAggregator.modifiedRows, statsAggregator.deletedRows);
            for (Map.Entry<FinderType.Annotation, HitMissCounter> e : statsAggregator.annotated.entrySet()) {
                this.getCounter(e.getKey()).update(e.getValue());
            }
            this.hitMissCounter.update(statsAggregator.hitMissCounter);
        }

        String getRowStats() {
            return String.format("N=%-4d M=%-4d R=%-4d", this.newRows, this.modifiedRows, this.deletedRows);
        }

        String getHitsMisses() {
            return this.hitMissCounter.toString();
        }

        String getDetailedMisses() {
            if (this.annotated.isEmpty()) {
                return "";
            }
            try (Formatter formatter = new Formatter();){
                formatter.format("Detailed Misses: ", new Object[0]);
                for (Map.Entry<FinderType.Annotation, HitMissCounter> e : this.annotated.entrySet()) {
                    String onlyMisses = e.getValue().onlyMisses();
                    if (onlyMisses.isEmpty()) continue;
                    formatter.format("%s %s ", e.getKey().getShort(), onlyMisses);
                }
                String string = formatter.toString();
                return string;
            }
        }

        boolean isEmpty() {
            return this.newRows == 0 && this.modifiedRows == 0 && this.deletedRows == 0;
        }

        String toString(String prefix) {
            String detailedMisses;
            StringBuilder sb = new StringBuilder();
            sb.append(prefix + "  " + this.getRowStats() + EntityContextStat.NEW_LINE);
            String hitMisses = this.getHitsMisses();
            if (!hitMisses.isEmpty()) {
                sb.append(prefix + "  " + hitMisses + EntityContextStat.NEW_LINE);
            }
            if (!(detailedMisses = this.getDetailedMisses()).isEmpty()) {
                sb.append(prefix + "  " + detailedMisses + EntityContextStat.NEW_LINE);
            }
            return sb.toString();
        }

        String toCSFString(String prefix) {
            String detailedMisses;
            StringBuilder sb = new StringBuilder();
            sb.append(EntityContextStat.getCSF(prefix + "  " + this.getRowStats(), new Object[0]));
            String hitMisses = this.getHitsMisses();
            if (!hitMisses.isEmpty()) {
                sb.append(EntityContextStat.getCSF(prefix + "  " + hitMisses, new Object[0]));
            }
            if (!(detailedMisses = this.getDetailedMisses()).isEmpty()) {
                sb.append(EntityContextStat.getCSF(prefix + "  " + detailedMisses, new Object[0]));
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString("");
        }
    }
}

