/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.avro.file;

import io.hops.hadoop.shaded.org.apache.avro.file.Codec;
import io.hops.hadoop.shaded.org.apache.avro.file.CodecFactory;
import io.hops.hadoop.shaded.org.apache.avro.file.ZstandardLoader;
import io.hops.hadoop.shaded.org.apache.commons.compress.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ZstandardCodec
extends Codec {
    private final int compressionLevel;
    private final boolean useChecksum;
    private ByteArrayOutputStream outputBuffer;

    public ZstandardCodec(int compressionLevel, boolean useChecksum) {
        this.compressionLevel = compressionLevel;
        this.useChecksum = useChecksum;
    }

    @Override
    public String getName() {
        return "zstandard";
    }

    @Override
    public ByteBuffer compress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data.remaining());
        try (OutputStream outputStream = ZstandardLoader.output(baos, this.compressionLevel, this.useChecksum);){
            outputStream.write(data.array(), ZstandardCodec.computeOffset(data), data.remaining());
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    @Override
    public ByteBuffer decompress(ByteBuffer compressedData) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(compressedData.remaining());
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(compressedData.array(), ZstandardCodec.computeOffset(compressedData), compressedData.remaining());
        try (InputStream ios = ZstandardLoader.input(bytesIn);){
            IOUtils.copy(ios, (OutputStream)baos);
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && obj.getClass() == this.getClass();
    }

    @Override
    public String toString() {
        return this.getName() + "[" + this.compressionLevel + "]";
    }

    static class Option
    extends CodecFactory {
        private final int compressionLevel;
        private final boolean useChecksum;

        Option(int compressionLevel, boolean useChecksum) {
            this.compressionLevel = compressionLevel;
            this.useChecksum = useChecksum;
        }

        @Override
        protected Codec createInstance() {
            return new ZstandardCodec(this.compressionLevel, this.useChecksum);
        }
    }
}

