/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.configuration2.convert;

import io.hops.hadoop.shaded.org.apache.commons.configuration2.convert.ListDelimiterHandler;
import io.hops.hadoop.shaded.org.apache.commons.configuration2.convert.ValueTransformer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractListDelimiterHandler
implements ListDelimiterHandler {
    @Override
    public Iterable<?> parse(Object value) {
        return this.flatten(value);
    }

    @Override
    public Collection<String> split(String s2, boolean trim) {
        if (s2 == null) {
            return new ArrayList<String>(0);
        }
        return this.splitString(s2, trim);
    }

    @Override
    public Object escape(Object value, ValueTransformer transformer) {
        Object escValue = value instanceof String ? this.escapeString((String)value) : value;
        return transformer.transformValue(escValue);
    }

    protected abstract Collection<String> splitString(String var1, boolean var2);

    protected abstract String escapeString(String var1);

    Collection<?> flatten(Object value, int limit) {
        if (value instanceof String) {
            return this.split((String)value, true);
        }
        LinkedList<Object> result = new LinkedList<Object>();
        if (value instanceof Iterable) {
            this.flattenIterator(result, ((Iterable)value).iterator(), limit);
        } else if (value instanceof Iterator) {
            this.flattenIterator(result, (Iterator)value, limit);
        } else if (value != null) {
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                int size = 0;
                for (int idx = 0; idx < len && size < limit; ++idx) {
                    result.addAll(this.flatten(Array.get(value, idx), limit - size));
                    size = result.size();
                }
            } else {
                result.add(value);
            }
        }
        return result;
    }

    private Collection<?> flatten(Object value) {
        return this.flatten(value, Integer.MAX_VALUE);
    }

    private void flattenIterator(Collection<Object> target, Iterator<?> it, int limit) {
        int size = target.size();
        while (size < limit && it.hasNext()) {
            target.addAll(this.flatten(it.next(), limit - size));
            size = target.size();
        }
    }
}

