/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.curator;

import io.hops.hadoop.shaded.org.apache.curator.CuratorZookeeperClient;
import io.hops.hadoop.shaded.org.apache.curator.RetryLoopImpl;
import io.hops.hadoop.shaded.org.apache.curator.RetrySleeper;
import io.hops.hadoop.shaded.org.apache.curator.connection.ThreadLocalRetryLoop;
import io.hops.hadoop.shaded.org.apache.curator.utils.ThreadUtils;
import java.util.concurrent.Callable;

public abstract class RetryLoop {
    public static RetrySleeper getDefaultRetrySleeper() {
        return RetryLoopImpl.getRetrySleeper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        client.internalBlockUntilConnectedOrTimedOut();
        T result = null;
        ThreadLocalRetryLoop threadLocalRetryLoop = new ThreadLocalRetryLoop();
        RetryLoop retryLoop = threadLocalRetryLoop.getRetryLoop(client::newRetryLoop);
        try {
            while (retryLoop.shouldContinue()) {
                try {
                    result = proc.call();
                    retryLoop.markComplete();
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    retryLoop.takeException(e);
                }
            }
        }
        finally {
            threadLocalRetryLoop.release();
        }
        return result;
    }

    public abstract boolean shouldContinue();

    public abstract void markComplete();

    public abstract void takeException(Exception var1) throws Exception;
}

