/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.curator.framework.recipes.queue;

import io.hops.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.queue.DistributedDelayQueue;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.queue.DistributedIdQueue;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.queue.DistributedPriorityQueue;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.queue.DistributedQueue;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.queue.QueueConsumer;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.queue.QueueSerializer;
import io.hops.hadoop.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.hops.hadoop.shaded.org.apache.curator.shaded.com.google.common.util.concurrent.MoreExecutors;
import io.hops.hadoop.shaded.org.apache.curator.utils.PathUtils;
import io.hops.hadoop.shaded.org.apache.curator.utils.ThreadUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class QueueBuilder<T> {
    private final CuratorFramework client;
    private final QueueConsumer<T> consumer;
    private final QueueSerializer<T> serializer;
    private final String queuePath;
    private ThreadFactory factory;
    private Executor executor;
    private String lockPath;
    private int maxItems = Integer.MAX_VALUE;
    private boolean putInBackground = true;
    private int finalFlushMs = 5000;
    static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory("QueueBuilder");
    static final int NOT_SET = Integer.MAX_VALUE;

    public static <T> QueueBuilder<T> builder(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath) {
        return new QueueBuilder<T>(client, consumer, serializer, queuePath);
    }

    public DistributedQueue<T> buildQueue() {
        return new DistributedQueue<T>(this.client, this.consumer, this.serializer, this.queuePath, this.factory, this.executor, Integer.MAX_VALUE, false, this.lockPath, this.maxItems, this.putInBackground, this.finalFlushMs);
    }

    public DistributedIdQueue<T> buildIdQueue() {
        return new DistributedIdQueue<T>(this.client, this.consumer, this.serializer, this.queuePath, this.factory, this.executor, Integer.MAX_VALUE, false, this.lockPath, this.maxItems, this.putInBackground, this.finalFlushMs);
    }

    public DistributedPriorityQueue<T> buildPriorityQueue(int minItemsBeforeRefresh) {
        return new DistributedPriorityQueue<T>(this.client, this.consumer, this.serializer, this.queuePath, this.factory, this.executor, minItemsBeforeRefresh, this.lockPath, this.maxItems, this.putInBackground, this.finalFlushMs);
    }

    public DistributedDelayQueue<T> buildDelayQueue() {
        return new DistributedDelayQueue<T>(this.client, this.consumer, this.serializer, this.queuePath, this.factory, this.executor, Integer.MAX_VALUE, this.lockPath, this.maxItems, this.putInBackground, this.finalFlushMs);
    }

    public QueueBuilder<T> threadFactory(ThreadFactory factory) {
        Preconditions.checkNotNull(factory, "factory cannot be null");
        this.factory = factory;
        return this;
    }

    public QueueBuilder<T> executor(Executor executor) {
        Preconditions.checkNotNull(executor, "executor cannot be null");
        this.executor = executor;
        return this;
    }

    public QueueBuilder<T> lockPath(String path) {
        this.lockPath = PathUtils.validatePath(path);
        return this;
    }

    public QueueBuilder<T> maxItems(int maxItems) {
        this.maxItems = maxItems;
        this.putInBackground = false;
        return this;
    }

    public QueueBuilder<T> putInBackground(boolean putInBackground) {
        this.putInBackground = putInBackground;
        return this;
    }

    public QueueBuilder<T> finalFlushTime(int time, TimeUnit unit) {
        this.finalFlushMs = (int)unit.toMillis(time);
        return this;
    }

    private QueueBuilder(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath) {
        this.client = client;
        this.consumer = consumer;
        this.serializer = serializer;
        this.queuePath = PathUtils.validatePath(queuePath);
        this.factory = defaultThreadFactory;
        this.executor = MoreExecutors.directExecutor();
    }
}

