/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.math3.random;

import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.BetaDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.BinomialDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.CauchyDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.ChiSquaredDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.ExponentialDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.FDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.GammaDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.HypergeometricDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.PascalDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.PoissonDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.TDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.WeibullDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.ZipfDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.MathInternalError;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NotANumberException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NotFiniteNumberException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NotPositiveException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.util.Localizable;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import io.hops.hadoop.shaded.org.apache.commons.math3.random.RandomData;
import io.hops.hadoop.shaded.org.apache.commons.math3.random.RandomGenerator;
import io.hops.hadoop.shaded.org.apache.commons.math3.random.Well19937c;
import io.hops.hadoop.shaded.org.apache.commons.math3.util.FastMath;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDataGenerator
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataGenerator() {
    }

    public RandomDataGenerator(RandomGenerator rand) {
        this.rand = rand;
    }

    @Override
    public String nextHexString(int len) throws NotStrictlyPositiveException {
        if (len <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, len);
        }
        RandomGenerator ran = this.getRan();
        StringBuilder outBuffer = new StringBuilder();
        byte[] randomBytes = new byte[len / 2 + 1];
        ran.nextBytes(randomBytes);
        for (int i = 0; i < randomBytes.length; ++i) {
            Integer c = randomBytes[i];
            String hex = Integer.toHexString(c + 128);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            outBuffer.append(hex);
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextInt(int lower, int upper) throws NumberIsTooLargeException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        double r = this.getRan().nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (int)FastMath.floor(scaled);
    }

    @Override
    public long nextLong(long lower, long upper) throws NumberIsTooLargeException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        double r = this.getRan().nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (long)FastMath.floor(scaled);
    }

    @Override
    public String nextSecureHexString(int len) throws NotStrictlyPositiveException {
        if (len <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, len);
        }
        SecureRandom secRan = this.getSecRan();
        MessageDigest alg = null;
        try {
            alg = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new MathInternalError(ex);
        }
        alg.reset();
        int numIter = len / 40 + 1;
        StringBuilder outBuffer = new StringBuilder();
        for (int iter = 1; iter < numIter + 1; ++iter) {
            byte[] randomBytes = new byte[40];
            secRan.nextBytes(randomBytes);
            alg.update(randomBytes);
            byte[] hash = alg.digest();
            for (int i = 0; i < hash.length; ++i) {
                Integer c = hash[i];
                String hex = Integer.toHexString(c + 128);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                outBuffer.append(hex);
            }
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextSecureInt(int lower, int upper) throws NumberIsTooLargeException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        SecureRandom sec = this.getSecRan();
        double r = sec.nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (int)FastMath.floor(scaled);
    }

    @Override
    public long nextSecureLong(long lower, long upper) throws NumberIsTooLargeException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        SecureRandom sec = this.getSecRan();
        double r = sec.nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (long)FastMath.floor(scaled);
    }

    @Override
    public long nextPoisson(double mean) throws NotStrictlyPositiveException {
        return new PoissonDistribution(this.getRan(), mean, 1.0E-12, 10000000).sample();
    }

    @Override
    public double nextGaussian(double mu, double sigma) throws NotStrictlyPositiveException {
        if (sigma <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, sigma);
        }
        return sigma * this.getRan().nextGaussian() + mu;
    }

    @Override
    public double nextExponential(double mean) throws NotStrictlyPositiveException {
        return new ExponentialDistribution(this.getRan(), mean, 1.0E-9).sample();
    }

    public double nextGamma(double shape, double scale) throws NotStrictlyPositiveException {
        return new GammaDistribution(this.getRan(), shape, scale, 1.0E-9).sample();
    }

    public int nextHypergeometric(int populationSize, int numberOfSuccesses, int sampleSize) throws NotPositiveException, NotStrictlyPositiveException, NumberIsTooLargeException {
        return new HypergeometricDistribution(this.getRan(), populationSize, numberOfSuccesses, sampleSize).sample();
    }

    public int nextPascal(int r, double p) throws NotStrictlyPositiveException, OutOfRangeException {
        return new PascalDistribution(this.getRan(), r, p).sample();
    }

    public double nextT(double df) throws NotStrictlyPositiveException {
        return new TDistribution(this.getRan(), df, 1.0E-9).sample();
    }

    public double nextWeibull(double shape, double scale) throws NotStrictlyPositiveException {
        return new WeibullDistribution(this.getRan(), shape, scale, 1.0E-9).sample();
    }

    public int nextZipf(int numberOfElements, double exponent) throws NotStrictlyPositiveException {
        return new ZipfDistribution(this.getRan(), numberOfElements, exponent).sample();
    }

    public double nextBeta(double alpha, double beta) {
        return new BetaDistribution(this.getRan(), alpha, beta, 1.0E-9).sample();
    }

    public int nextBinomial(int numberOfTrials, double probabilityOfSuccess) {
        return new BinomialDistribution(this.getRan(), numberOfTrials, probabilityOfSuccess).sample();
    }

    public double nextCauchy(double median, double scale) {
        return new CauchyDistribution(this.getRan(), median, scale, 1.0E-9).sample();
    }

    public double nextChiSquare(double df) {
        return new ChiSquaredDistribution(this.getRan(), df, 1.0E-9).sample();
    }

    public double nextF(double numeratorDf, double denominatorDf) throws NotStrictlyPositiveException {
        return new FDistribution(this.getRan(), numeratorDf, denominatorDf, 1.0E-9).sample();
    }

    @Override
    public double nextUniform(double lower, double upper) throws NumberIsTooLargeException, NotFiniteNumberException, NotANumberException {
        return this.nextUniform(lower, upper, false);
    }

    @Override
    public double nextUniform(double lower, double upper, boolean lowerInclusive) throws NumberIsTooLargeException, NotFiniteNumberException, NotANumberException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        if (Double.isInfinite(lower)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, lower, new Object[0]);
        }
        if (Double.isInfinite(upper)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, upper, new Object[0]);
        }
        if (Double.isNaN(lower) || Double.isNaN(upper)) {
            throw new NotANumberException();
        }
        RandomGenerator generator = this.getRan();
        double u = generator.nextDouble();
        while (!lowerInclusive && u <= 0.0) {
            u = generator.nextDouble();
        }
        return u * upper + (1.0 - u) * lower;
    }

    @Override
    public int[] nextPermutation(int n, int k) throws NumberIsTooLargeException, NotStrictlyPositiveException {
        if (k > n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.PERMUTATION_EXCEEDS_N, (Number)k, n, true);
        }
        if (k <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.PERMUTATION_SIZE, k);
        }
        int[] index = this.getNatural(n);
        this.shuffle(index, n - k);
        int[] result = new int[k];
        for (int i = 0; i < k; ++i) {
            result[i] = index[n - i - 1];
        }
        return result;
    }

    @Override
    public Object[] nextSample(Collection<?> c, int k) throws NumberIsTooLargeException, NotStrictlyPositiveException {
        int len = c.size();
        if (k > len) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, (Number)k, len, true);
        }
        if (k <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, k);
        }
        Object[] objects = c.toArray();
        int[] index = this.nextPermutation(len, k);
        Object[] result = new Object[k];
        for (int i = 0; i < k; ++i) {
            result[i] = objects[index[i]];
        }
        return result;
    }

    public void reSeed(long seed) {
        this.getRan().setSeed(seed);
    }

    public void reSeedSecure() {
        this.getSecRan().setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long seed) {
        this.getSecRan().setSeed(seed);
    }

    public void reSeed() {
        this.getRan().setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public void setSecureAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = SecureRandom.getInstance(algorithm, provider);
    }

    private RandomGenerator getRan() {
        if (this.rand == null) {
            this.initRan();
        }
        return this.rand;
    }

    private void initRan() {
        this.rand = new Well19937c(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
        }
        return this.secRand;
    }

    private void shuffle(int[] list, int end) {
        int target = 0;
        for (int i = list.length - 1; i >= end; --i) {
            target = i == 0 ? 0 : this.nextInt(0, i);
            int temp = list[target];
            list[target] = list[i];
            list[i] = temp;
        }
    }

    private int[] getNatural(int n) {
        int[] natural = new int[n];
        for (int i = 0; i < n; ++i) {
            natural[i] = i;
        }
        return natural;
    }
}

