/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base;

import io.hops.hadoop.shaded.org.apache.kerby.asn1.parse.Asn1ParseResult;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbRuntime;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KrbTokenBase;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.TokenFormat;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class KrbToken
extends KrbTokenBase
implements AuthToken {
    private static TokenEncoder tokenEncoder;
    private static TokenDecoder tokenDecoder;
    private AuthToken innerToken = null;

    public KrbToken() {
    }

    public KrbToken(AuthToken authToken, TokenFormat format) {
        this();
        this.innerToken = authToken;
        this.setTokenType();
        this.setTokenFormat(format);
        try {
            this.setTokenValue(KrbToken.getTokenEncoder(format).encodeAsBytes(this.innerToken));
        }
        catch (KrbException e) {
            throw new RuntimeException("Failed to encode AuthToken", e);
        }
    }

    public AuthToken getAuthToken() {
        return this.innerToken;
    }

    @Override
    public void decode(Asn1ParseResult parseResult) throws IOException {
        super.decode(parseResult);
        if (this.getTokenValue() != null) {
            this.innerToken = KrbToken.getTokenDecoder(this.getTokenFormat()).decodeFromBytes(this.getTokenValue());
            this.setTokenType();
        }
    }

    public void setTokenType() {
        List<String> audiences = this.innerToken.getAudiences();
        if (audiences != null && audiences.size() == 1 && audiences.get(0).startsWith("krbtgt")) {
            this.isIdToken(true);
        } else {
            this.isAcToken(true);
        }
    }

    protected static TokenEncoder getTokenEncoder(TokenFormat format) {
        if (tokenEncoder == null) {
            tokenEncoder = KrbRuntime.getTokenProvider(format.getName()).createTokenEncoder();
        }
        return tokenEncoder;
    }

    protected static TokenDecoder getTokenDecoder(TokenFormat format) {
        if (tokenDecoder == null) {
            tokenDecoder = KrbRuntime.getTokenProvider(format.getName()).createTokenDecoder();
        }
        return tokenDecoder;
    }

    @Override
    public String getSubject() {
        return this.innerToken.getSubject();
    }

    @Override
    public void setSubject(String sub) {
        this.innerToken.setSubject(sub);
    }

    @Override
    public String getIssuer() {
        return this.innerToken.getIssuer();
    }

    @Override
    public void setIssuer(String issuer) {
        this.innerToken.setIssuer(issuer);
    }

    @Override
    public List<String> getAudiences() {
        return this.innerToken.getAudiences();
    }

    @Override
    public void setAudiences(List<String> audiences) {
        this.innerToken.setAudiences(audiences);
    }

    @Override
    public boolean isIdToken() {
        return this.innerToken.isIdToken();
    }

    @Override
    public void isIdToken(boolean isIdToken) {
        this.innerToken.isIdToken(isIdToken);
    }

    @Override
    public boolean isAcToken() {
        return this.innerToken.isAcToken();
    }

    @Override
    public void isAcToken(boolean isAcToken) {
        this.innerToken.isAcToken(isAcToken);
    }

    @Override
    public boolean isBearerToken() {
        return this.innerToken.isBearerToken();
    }

    @Override
    public boolean isHolderOfKeyToken() {
        return this.innerToken.isHolderOfKeyToken();
    }

    @Override
    public Date getExpiredTime() {
        return this.innerToken.getExpiredTime();
    }

    @Override
    public void setExpirationTime(Date exp) {
        this.innerToken.setExpirationTime(exp);
    }

    @Override
    public Date getNotBeforeTime() {
        return this.innerToken.getNotBeforeTime();
    }

    @Override
    public void setNotBeforeTime(Date nbt) {
        this.innerToken.setNotBeforeTime(nbt);
    }

    @Override
    public Date getIssueTime() {
        return this.innerToken.getIssueTime();
    }

    @Override
    public void setIssueTime(Date iat) {
        this.innerToken.setIssueTime(iat);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.innerToken.getAttributes();
    }

    @Override
    public void addAttribute(String name, Object value) {
        this.innerToken.addAttribute(name, value);
    }

    public void setInnerToken(AuthToken authToken) {
        this.innerToken = authToken;
    }
}

