/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.google.gson.internal.sql;

import io.hops.hadoop.shaded.com.google.gson.Gson;
import io.hops.hadoop.shaded.com.google.gson.JsonSyntaxException;
import io.hops.hadoop.shaded.com.google.gson.TypeAdapter;
import io.hops.hadoop.shaded.com.google.gson.TypeAdapterFactory;
import io.hops.hadoop.shaded.com.google.gson.reflect.TypeToken;
import io.hops.hadoop.shaded.com.google.gson.stream.JsonReader;
import io.hops.hadoop.shaded.com.google.gson.stream.JsonToken;
import io.hops.hadoop.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new SqlTimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String s2 = in.nextString();
        try {
            SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
            synchronized (sqlTimeTypeAdapter) {
                Date date = this.format.parse(s2);
                return new Time(date.getTime());
            }
        }
        catch (ParseException e) {
            throw new JsonSyntaxException("Failed parsing '" + s2 + "' as SQL Time; at path " + in.getPreviousPath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter out, Time value) throws IOException {
        String timeString;
        if (value == null) {
            out.nullValue();
            return;
        }
        SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
        synchronized (sqlTimeTypeAdapter) {
            timeString = this.format.format(value);
        }
        out.value(timeString);
    }
}

