/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.datatype.guava.deser;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonParser;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonToken;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.net.HostAndPort;
import java.io.IOException;

public class HostAndPortDeserializer
extends FromStringDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    @Override
    public HostAndPort deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.START_OBJECT)) {
            JsonNode root = (JsonNode)p.readValueAsTree();
            JsonNode hostNode = root.get("host");
            String host = hostNode == null ? root.path("hostText").asText() : hostNode.textValue();
            JsonNode n = root.get("port");
            if (n == null) {
                return HostAndPort.fromString(host);
            }
            return HostAndPort.fromParts(host, n.asInt());
        }
        return (HostAndPort)super.deserialize(p, ctxt);
    }

    @Override
    protected HostAndPort _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return HostAndPort.fromString(value);
    }
}

