/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.datatype.jdk8;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.BeanProperty;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.JavaType;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.MapperFeature;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.datatype.jdk8.WrappedIOException;
import java.io.IOException;
import java.util.stream.Stream;

public class StreamSerializer
extends StdSerializer<Stream<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final JavaType elemType;
    private final transient JsonSerializer<Object> elemSerializer;

    public StreamSerializer(JavaType streamType, JavaType elemType) {
        this(streamType, elemType, null);
    }

    public StreamSerializer(JavaType streamType, JavaType elemType, JsonSerializer<Object> elemSerializer) {
        super(streamType);
        this.elemType = elemType;
        this.elemSerializer = elemSerializer;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (!this.elemType.hasRawClass(Object.class) && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this.elemType.isFinal())) {
            return new StreamSerializer(provider.getTypeFactory().constructParametricType(Stream.class, this.elemType), this.elemType, provider.findPrimaryPropertySerializer(this.elemType, property));
        }
        return this;
    }

    @Override
    public void serialize(Stream<?> stream, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try (Stream<?> s2 = stream;){
            jgen.writeStartArray();
            s2.forEachOrdered(elem -> {
                try {
                    if (this.elemSerializer == null) {
                        provider.defaultSerializeValue(elem, jgen);
                    } else {
                        this.elemSerializer.serialize(elem, jgen, provider);
                    }
                }
                catch (IOException e) {
                    throw new WrappedIOException(e);
                }
            });
            jgen.writeEndArray();
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
    }
}

