/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.BaseClient;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.async.Callback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.async.ConsulResponseCallback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.config.ClientConfig;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.ConsulResponse;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.monitoring.ClientEventCallback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.okhttp3.MediaType;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.okhttp3.RequestBody;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.okhttp3.ResponseBody;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.Call;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.Retrofit;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.Body;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.GET;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.Headers;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.PUT;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.QueryMap;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.Streaming;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;

public class SnapshotClient
extends BaseClient {
    private static String CLIENT_NAME = "snapshot";
    private final Api api;

    SnapshotClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = retrofit.create(Api.class);
    }

    public void save(final File destinationFile, QueryOptions queryOptions, final Callback<BigInteger> callback) {
        this.http.extractConsulResponse(this.api.generateSnapshot(queryOptions.toQuery()), new ConsulResponseCallback<ResponseBody>(){

            @Override
            public void onComplete(ConsulResponse<ResponseBody> consulResponse) {
                try (ResponseBody responseBody = consulResponse.getResponse();
                     InputStream inputStream = responseBody.byteStream();){
                    Files.copy(inputStream, destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    callback.onResponse(consulResponse.getIndex());
                }
                catch (IOException e) {
                    callback.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }
        }, new Integer[0]);
    }

    public void restore(File sourceFile, QueryOptions queryOptions, Callback<Void> callback) {
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/binary"), sourceFile);
        this.http.extractBasicResponse(this.api.restoreSnapshot(queryOptions.toQuery(), requestBody), callback, new Integer[0]);
    }

    static interface Api {
        @Streaming
        @GET(value="snapshot")
        public Call<ResponseBody> generateSnapshot(@QueryMap Map<String, Object> var1);

        @PUT(value="snapshot")
        @Headers(value={"Content-Type: application/binary"})
        public Call<Void> restoreSnapshot(@QueryMap Map<String, Object> var1, @Body RequestBody var2);
    }
}

