/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.cache;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.primitives.Ints;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.HealthClient;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.async.ConsulResponseCallback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.cache.CacheDescriptor;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.cache.ConsulCache;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.config.CacheConfig;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.State;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.HealthCheck;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class HealthCheckCache
extends ConsulCache<String, HealthCheck> {
    private HealthCheckCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor, ConsulCache.Scheduler callbackScheduler) {
        super(keyExtractor, (BigInteger index, ConsulResponseCallback<List<V>> callback) -> {
            QueryOptions params = HealthCheckCache.watchParams(index, watchSeconds, queryOptions);
            healthClient.getChecksByState(state, params, callback);
        }, healthClient.getConfig().getCacheConfig(), healthClient.getEventHandler(), new CacheDescriptor("health.state", state.getName()), callbackScheduler);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler callbackScheduler = HealthCheckCache.createExternal(callbackExecutorService);
        return new HealthCheckCache(healthClient, state, watchSeconds, queryOptions, keyExtractor, callbackScheduler);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor) {
        return new HealthCheckCache(healthClient, state, watchSeconds, queryOptions, keyExtractor, HealthCheckCache.createDefault());
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds, QueryOptions queryOptions) {
        return HealthCheckCache.newCache(healthClient, state, watchSeconds, queryOptions, HealthCheck::getCheckId);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state, int watchSeconds) {
        return HealthCheckCache.newCache(healthClient, state, watchSeconds, QueryOptions.BLANK);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state) {
        CacheConfig cacheConfig = healthClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast(cacheConfig.getWatchDuration().getSeconds());
        return HealthCheckCache.newCache(healthClient, state, watchSeconds);
    }
}

