/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent.Agent;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent.Config;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent.DebugConfig;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent.Member;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Agent", generator="Immutables")
@Immutable
public final class ImmutableAgent
extends Agent {
    private final Config config;
    @Nullable
    private final DebugConfig debugConfig;
    private final Member member;

    private ImmutableAgent(Config config, @Nullable DebugConfig debugConfig, Member member) {
        this.config = config;
        this.debugConfig = debugConfig;
        this.member = member;
    }

    @Override
    @JsonProperty(value="Config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="DebugConfig")
    @Nullable
    public DebugConfig getDebugConfig() {
        return this.debugConfig;
    }

    @Override
    @JsonProperty(value="Member")
    public Member getMember() {
        return this.member;
    }

    public final ImmutableAgent withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = Objects.requireNonNull(value, "config");
        return new ImmutableAgent(newValue, this.debugConfig, this.member);
    }

    public final ImmutableAgent withDebugConfig(@Nullable DebugConfig value) {
        if (this.debugConfig == value) {
            return this;
        }
        return new ImmutableAgent(this.config, value, this.member);
    }

    public final ImmutableAgent withMember(Member value) {
        if (this.member == value) {
            return this;
        }
        Member newValue = Objects.requireNonNull(value, "member");
        return new ImmutableAgent(this.config, this.debugConfig, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAgent && this.equalTo((ImmutableAgent)another);
    }

    private boolean equalTo(ImmutableAgent another) {
        return this.config.equals(another.config) && Objects.equals(this.debugConfig, another.debugConfig) && this.member.equals(another.member);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.config.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.debugConfig);
        h2 += (h2 << 5) + this.member.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Agent").omitNullValues().add("config", this.config).add("debugConfig", this.debugConfig).add("member", this.member).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAgent fromJson(Json json) {
        Builder builder = ImmutableAgent.builder();
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.debugConfig != null) {
            builder.debugConfig(json.debugConfig);
        }
        if (json.member != null) {
            builder.member(json.member);
        }
        return builder.build();
    }

    public static ImmutableAgent copyOf(Agent instance) {
        if (instance instanceof ImmutableAgent) {
            return (ImmutableAgent)instance;
        }
        return ImmutableAgent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Agent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONFIG = 1L;
        private static final long INIT_BIT_MEMBER = 2L;
        private long initBits = 3L;
        @Nullable
        private Config config;
        @Nullable
        private DebugConfig debugConfig;
        @Nullable
        private Member member;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Agent instance) {
            Objects.requireNonNull(instance, "instance");
            this.config(instance.getConfig());
            DebugConfig debugConfigValue = instance.getDebugConfig();
            if (debugConfigValue != null) {
                this.debugConfig(debugConfigValue);
            }
            this.member(instance.getMember());
            return this;
        }

        @JsonProperty(value="Config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="DebugConfig")
        @CanIgnoreReturnValue
        public final Builder debugConfig(@Nullable DebugConfig debugConfig) {
            this.debugConfig = debugConfig;
            return this;
        }

        @JsonProperty(value="Member")
        @CanIgnoreReturnValue
        public final Builder member(Member member) {
            this.member = Objects.requireNonNull(member, "member");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAgent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAgent(this.config, this.debugConfig, this.member);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("member");
            }
            return "Cannot build Agent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Agent", generator="Immutables")
    static final class Json
    extends Agent {
        @Nullable
        Config config;
        @Nullable
        DebugConfig debugConfig;
        @Nullable
        Member member;

        Json() {
        }

        @JsonProperty(value="Config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="DebugConfig")
        public void setDebugConfig(@Nullable DebugConfig debugConfig) {
            this.debugConfig = debugConfig;
        }

        @JsonProperty(value="Member")
        public void setMember(Member member) {
            this.member = member;
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DebugConfig getDebugConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Member getMember() {
            throw new UnsupportedOperationException();
        }
    }
}

