/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableList;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.catalog.ServiceWeights;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.Service;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Service", generator="Immutables")
@Immutable
public final class ImmutableService
extends Service {
    private final String id;
    private final String service;
    @Nullable
    private final Boolean enableTagOverride;
    private final ImmutableList<String> tags;
    private final String address;
    private final ImmutableMap<String, String> meta;
    private final int port;
    @Nullable
    private final ServiceWeights weights;

    private ImmutableService(String id, String service, @Nullable Boolean enableTagOverride, ImmutableList<String> tags, String address, ImmutableMap<String, String> meta, int port, @Nullable ServiceWeights weights) {
        this.id = id;
        this.service = service;
        this.enableTagOverride = enableTagOverride;
        this.tags = tags;
        this.address = address;
        this.meta = meta;
        this.port = port;
        this.weights = weights;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Service")
    public String getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="EnableTagOverride")
    public Optional<Boolean> getEnableTagOverride() {
        return Optional.ofNullable(this.enableTagOverride);
    }

    @JsonProperty(value="Tags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="Meta")
    public ImmutableMap<String, String> getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="Port")
    public int getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="Weights")
    public Optional<ServiceWeights> getWeights() {
        return Optional.ofNullable(this.weights);
    }

    public final ImmutableService withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableService(newValue, this.service, this.enableTagOverride, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withService(String value) {
        String newValue = Objects.requireNonNull(value, "service");
        if (this.service.equals(newValue)) {
            return this;
        }
        return new ImmutableService(this.id, newValue, this.enableTagOverride, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableService(this.id, this.service, newValue, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableTagOverride, value)) {
            return this;
        }
        return new ImmutableService(this.id, this.service, value, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withTags(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableService(this.id, this.service, this.enableTagOverride, newValue, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableService(this.id, this.service, this.enableTagOverride, newValue, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, newValue, this.meta, this.port, this.weights);
    }

    public final ImmutableService withMeta(Map<String, ? extends String> entries) {
        if (this.meta == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, newValue, this.port, this.weights);
    }

    public final ImmutableService withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, this.meta, value, this.weights);
    }

    public final ImmutableService withWeights(ServiceWeights value) {
        ServiceWeights newValue = Objects.requireNonNull(value, "weights");
        if (this.weights == newValue) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, this.meta, this.port, newValue);
    }

    public final ImmutableService withWeights(Optional<? extends ServiceWeights> optional) {
        ServiceWeights value = optional.orElse(null);
        if (this.weights == value) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, this.meta, this.port, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableService && this.equalTo((ImmutableService)another);
    }

    private boolean equalTo(ImmutableService another) {
        return this.id.equals(another.id) && this.service.equals(another.service) && Objects.equals(this.enableTagOverride, another.enableTagOverride) && this.tags.equals(another.tags) && this.address.equals(another.address) && this.meta.equals(another.meta) && this.port == another.port && Objects.equals(this.weights, another.weights);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.id.hashCode();
        h2 += (h2 << 5) + this.service.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.enableTagOverride);
        h2 += (h2 << 5) + this.tags.hashCode();
        h2 += (h2 << 5) + this.address.hashCode();
        h2 += (h2 << 5) + this.meta.hashCode();
        h2 += (h2 << 5) + this.port;
        h2 += (h2 << 5) + Objects.hashCode(this.weights);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Service").omitNullValues().add("id", this.id).add("service", this.service).add("enableTagOverride", this.enableTagOverride).add("tags", this.tags).add("address", this.address).add("meta", this.meta).add("port", this.port).add("weights", this.weights).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableService fromJson(Json json) {
        Builder builder = ImmutableService.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.enableTagOverride != null) {
            builder.enableTagOverride(json.enableTagOverride);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.meta != null) {
            builder.putAllMeta(json.meta);
        }
        if (json.portIsSet) {
            builder.port(json.port);
        }
        if (json.weights != null) {
            builder.weights(json.weights);
        }
        return builder.build();
    }

    public static ImmutableService copyOf(Service instance) {
        if (instance instanceof ImmutableService) {
            return (ImmutableService)instance;
        }
        return ImmutableService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Service", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_PORT = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String service;
        @Nullable
        private Boolean enableTagOverride;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        @Nullable
        private String address;
        private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();
        private int port;
        @Nullable
        private ServiceWeights weights;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Service instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.service(instance.getService());
            Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
            if (enableTagOverrideOptional.isPresent()) {
                this.enableTagOverride(enableTagOverrideOptional);
            }
            this.addAllTags(instance.getTags());
            this.address(instance.getAddress());
            this.putAllMeta(instance.getMeta());
            this.port(instance.getPort());
            Optional<ServiceWeights> weightsOptional = instance.getWeights();
            if (weightsOptional.isPresent()) {
                this.weights(weightsOptional);
            }
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(String service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableTagOverride(boolean enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
            return this;
        }

        @JsonProperty(value="EnableTagOverride")
        @CanIgnoreReturnValue
        public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add(elements);
            return this;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(String key, String value) {
            this.meta.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
            this.meta.put(entry);
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder meta(Map<String, ? extends String> entries) {
            this.meta = ImmutableMap.builder();
            return this.putAllMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMeta(Map<String, ? extends String> entries) {
            this.meta.putAll(entries);
            return this;
        }

        @JsonProperty(value="Port")
        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder weights(ServiceWeights weights) {
            this.weights = Objects.requireNonNull(weights, "weights");
            return this;
        }

        @JsonProperty(value="Weights")
        @CanIgnoreReturnValue
        public final Builder weights(Optional<? extends ServiceWeights> weights) {
            this.weights = weights.orElse(null);
            return this;
        }

        public ImmutableService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableService(this.id, this.service, this.enableTagOverride, (ImmutableList)this.tags.build(), this.address, this.meta.build(), this.port, this.weights);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build Service, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Service", generator="Immutables")
    static final class Json
    extends Service {
        @Nullable
        String id;
        @Nullable
        String service;
        @Nullable
        Optional<Boolean> enableTagOverride = Optional.empty();
        @Nullable
        List<String> tags = ImmutableList.of();
        @Nullable
        String address;
        @Nullable
        Map<String, String> meta = ImmutableMap.of();
        int port;
        boolean portIsSet;
        @Nullable
        Optional<ServiceWeights> weights = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="EnableTagOverride")
        public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        @JsonProperty(value="Port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @JsonProperty(value="Weights")
        public void setWeights(Optional<ServiceWeights> weights) {
            this.weights = weights;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getEnableTagOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServiceWeights> getWeights() {
            throw new UnsupportedOperationException();
        }
    }
}

