/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableList;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.HealthCheck;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.Node;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.Service;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.ServiceHealth;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceHealth", generator="Immutables")
@Immutable
public final class ImmutableServiceHealth
extends ServiceHealth {
    private final Node node;
    private final Service service;
    private final ImmutableList<HealthCheck> checks;

    private ImmutableServiceHealth(Node node, Service service, ImmutableList<HealthCheck> checks) {
        this.node = node;
        this.service = service;
        this.checks = checks;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Service")
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="Checks")
    @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
    public ImmutableList<HealthCheck> getChecks() {
        return this.checks;
    }

    public final ImmutableServiceHealth withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        Node newValue = Objects.requireNonNull(value, "node");
        return new ImmutableServiceHealth(newValue, this.service, this.checks);
    }

    public final ImmutableServiceHealth withService(Service value) {
        if (this.service == value) {
            return this;
        }
        Service newValue = Objects.requireNonNull(value, "service");
        return new ImmutableServiceHealth(this.node, newValue, this.checks);
    }

    public final ImmutableServiceHealth withChecks(HealthCheck ... elements) {
        ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceHealth(this.node, this.service, newValue);
    }

    public final ImmutableServiceHealth withChecks(Iterable<? extends HealthCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceHealth(this.node, this.service, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceHealth && this.equalTo((ImmutableServiceHealth)another);
    }

    private boolean equalTo(ImmutableServiceHealth another) {
        return this.node.equals(another.node) && this.service.equals(another.service) && this.checks.equals(another.checks);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.node.hashCode();
        h2 += (h2 << 5) + this.service.hashCode();
        h2 += (h2 << 5) + this.checks.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceHealth").omitNullValues().add("node", this.node).add("service", this.service).add("checks", this.checks).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceHealth fromJson(Json json) {
        Builder builder = ImmutableServiceHealth.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        return builder.build();
    }

    public static ImmutableServiceHealth copyOf(ServiceHealth instance) {
        if (instance instanceof ImmutableServiceHealth) {
            return (ImmutableServiceHealth)instance;
        }
        return ImmutableServiceHealth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceHealth", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        @Nullable
        private Node node;
        @Nullable
        private Service service;
        private ImmutableList.Builder<HealthCheck> checks = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceHealth instance) {
            Objects.requireNonNull(instance, "instance");
            this.node(instance.getNode());
            this.service(instance.getService());
            this.addAllChecks(instance.getChecks());
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder node(Node node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(Service service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck element) {
            this.checks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck ... elements) {
            this.checks.add(elements);
            return this;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        @CanIgnoreReturnValue
        public final Builder checks(Iterable<? extends HealthCheck> elements) {
            this.checks = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
            this.checks.addAll(elements);
            return this;
        }

        public ImmutableServiceHealth build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceHealth(this.node, this.service, (ImmutableList)this.checks.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build ServiceHealth, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServiceHealth", generator="Immutables")
    static final class Json
    extends ServiceHealth {
        @Nullable
        Node node;
        @Nullable
        Service service;
        @Nullable
        List<HealthCheck> checks = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this.node = node;
        }

        @JsonProperty(value="Service")
        public void setService(Service service) {
            this.service = service;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        public void setChecks(List<HealthCheck> checks) {
            this.checks = checks;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Service getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<HealthCheck> getChecks() {
            throw new UnsupportedOperationException();
        }
    }
}

