/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.operator;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableList;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.operator.RaftConfiguration;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.operator.RaftServer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.immutables.value.Generated;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="RaftConfiguration", generator="Immutables")
@Immutable
public final class ImmutableRaftConfiguration
extends RaftConfiguration {
    private final ImmutableList<RaftServer> servers;
    private final BigInteger index;

    private ImmutableRaftConfiguration(ImmutableList<RaftServer> servers, BigInteger index) {
        this.servers = servers;
        this.index = index;
    }

    @JsonProperty(value="Servers")
    public ImmutableList<RaftServer> servers() {
        return this.servers;
    }

    @Override
    @JsonProperty(value="Index")
    public BigInteger index() {
        return this.index;
    }

    public final ImmutableRaftConfiguration withServers(RaftServer ... elements) {
        ImmutableList<RaftServer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableRaftConfiguration(newValue, this.index);
    }

    public final ImmutableRaftConfiguration withServers(Iterable<? extends RaftServer> elements) {
        if (this.servers == elements) {
            return this;
        }
        ImmutableList<RaftServer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableRaftConfiguration(newValue, this.index);
    }

    public final ImmutableRaftConfiguration withIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "index");
        if (this.index.equals(newValue)) {
            return this;
        }
        return new ImmutableRaftConfiguration(this.servers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRaftConfiguration && this.equalTo((ImmutableRaftConfiguration)another);
    }

    private boolean equalTo(ImmutableRaftConfiguration another) {
        return this.servers.equals(another.servers) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.servers.hashCode();
        h2 += (h2 << 5) + this.index.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("RaftConfiguration").omitNullValues().add("servers", this.servers).add("index", this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRaftConfiguration fromJson(Json json) {
        Builder builder = ImmutableRaftConfiguration.builder();
        if (json.servers != null) {
            builder.addAllServers(json.servers);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableRaftConfiguration copyOf(RaftConfiguration instance) {
        if (instance instanceof ImmutableRaftConfiguration) {
            return (ImmutableRaftConfiguration)instance;
        }
        return ImmutableRaftConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RaftConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<RaftServer> servers = ImmutableList.builder();
        @Nullable
        private BigInteger index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RaftConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllServers(instance.servers());
            this.index(instance.index());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServers(RaftServer element) {
            this.servers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServers(RaftServer ... elements) {
            this.servers.add(elements);
            return this;
        }

        @JsonProperty(value="Servers")
        @CanIgnoreReturnValue
        public final Builder servers(Iterable<? extends RaftServer> elements) {
            this.servers = ImmutableList.builder();
            return this.addAllServers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServers(Iterable<? extends RaftServer> elements) {
            this.servers.addAll(elements);
            return this;
        }

        @JsonProperty(value="Index")
        @CanIgnoreReturnValue
        public final Builder index(BigInteger index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRaftConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRaftConfiguration((ImmutableList)this.servers.build(), this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build RaftConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RaftConfiguration", generator="Immutables")
    static final class Json
    extends RaftConfiguration {
        @Nullable
        List<RaftServer> servers = ImmutableList.of();
        @Nullable
        BigInteger index;

        Json() {
        }

        @JsonProperty(value="Servers")
        public void setServers(List<RaftServer> servers) {
            this.servers = servers;
        }

        @JsonProperty(value="Index")
        public void setIndex(BigInteger index) {
            this.index = index;
        }

        @Override
        public List<RaftServer> servers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger index() {
            throw new UnsupportedOperationException();
        }
    }
}

