/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option.ParamAdder;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option.PutOptions;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PutOptions", generator="Immutables")
@Immutable
public final class ImmutablePutOptions
extends PutOptions {
    private final ImmutableMap<String, String> toHeaders;
    @Nullable
    private final Long cas;
    @Nullable
    private final String acquire;
    @Nullable
    private final String release;
    @Nullable
    private final String dc;
    @Nullable
    private final String token;

    private ImmutablePutOptions(ImmutableMap<String, String> toHeaders, @Nullable Long cas, @Nullable String acquire, @Nullable String release, @Nullable String dc, @Nullable String token) {
        this.toHeaders = toHeaders;
        this.cas = cas;
        this.acquire = acquire;
        this.release = release;
        this.dc = dc;
        this.token = token;
    }

    public ImmutableMap<String, String> toHeaders() {
        return this.toHeaders;
    }

    @Override
    public Optional<Long> getCas() {
        return Optional.ofNullable(this.cas);
    }

    @Override
    public Optional<String> getAcquire() {
        return Optional.ofNullable(this.acquire);
    }

    @Override
    public Optional<String> getRelease() {
        return Optional.ofNullable(this.release);
    }

    @Override
    public Optional<String> getDc() {
        return Optional.ofNullable(this.dc);
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public final ImmutablePutOptions withToHeaders(Map<String, ? extends String> entries) {
        if (this.toHeaders == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePutOptions(newValue, this.cas, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withCas(long value) {
        Long newValue = value;
        if (Objects.equals(this.cas, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, newValue, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withCas(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.cas, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, value, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(String value) {
        String newValue = Objects.requireNonNull(value, "acquire");
        if (Objects.equals(this.acquire, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, newValue, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.acquire, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, value, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(String value) {
        String newValue = Objects.requireNonNull(value, "release");
        if (Objects.equals(this.release, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, this.acquire, newValue, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.release, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, this.acquire, value, this.dc, this.token);
    }

    public final ImmutablePutOptions withDc(String value) {
        String newValue = Objects.requireNonNull(value, "dc");
        if (Objects.equals(this.dc, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, this.acquire, this.release, newValue, this.token);
    }

    public final ImmutablePutOptions withDc(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dc, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, this.acquire, this.release, value, this.token);
    }

    public final ImmutablePutOptions withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, this.acquire, this.release, this.dc, newValue);
    }

    public final ImmutablePutOptions withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toHeaders, this.cas, this.acquire, this.release, this.dc, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePutOptions && this.equalTo((ImmutablePutOptions)another);
    }

    private boolean equalTo(ImmutablePutOptions another) {
        return this.toHeaders.equals(another.toHeaders) && Objects.equals(this.cas, another.cas) && Objects.equals(this.acquire, another.acquire) && Objects.equals(this.release, another.release) && Objects.equals(this.dc, another.dc) && Objects.equals(this.token, another.token);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.toHeaders.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.cas);
        h2 += (h2 << 5) + Objects.hashCode(this.acquire);
        h2 += (h2 << 5) + Objects.hashCode(this.release);
        h2 += (h2 << 5) + Objects.hashCode(this.dc);
        h2 += (h2 << 5) + Objects.hashCode(this.token);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PutOptions").omitNullValues().add("toHeaders", this.toHeaders).add("cas", this.cas).add("acquire", this.acquire).add("release", this.release).add("dc", this.dc).add("token", this.token).toString();
    }

    public static ImmutablePutOptions copyOf(PutOptions instance) {
        if (instance instanceof ImmutablePutOptions) {
            return (ImmutablePutOptions)instance;
        }
        return ImmutablePutOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PutOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
        @Nullable
        private Long cas;
        @Nullable
        private String acquire;
        @Nullable
        private String release;
        @Nullable
        private String dc;
        @Nullable
        private String token;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PutOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ParamAdder instance;
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.putAllToHeaders(instance.toHeaders());
            }
            if (object instanceof PutOptions) {
                Optional<String> tokenOptional;
                Optional<String> dcOptional;
                Optional<String> releaseOptional;
                Optional<String> acquireOptional;
                instance = (PutOptions)object;
                Optional<Long> casOptional = ((PutOptions)instance).getCas();
                if (casOptional.isPresent()) {
                    this.cas(casOptional);
                }
                if ((acquireOptional = ((PutOptions)instance).getAcquire()).isPresent()) {
                    this.acquire(acquireOptional);
                }
                if ((releaseOptional = ((PutOptions)instance).getRelease()).isPresent()) {
                    this.release(releaseOptional);
                }
                if ((dcOptional = ((PutOptions)instance).getDc()).isPresent()) {
                    this.dc(dcOptional);
                }
                if ((tokenOptional = ((PutOptions)instance).getToken()).isPresent()) {
                    this.token(tokenOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(String key, String value) {
            this.toHeaders.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
            this.toHeaders.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toHeaders(Map<String, ? extends String> entries) {
            this.toHeaders = ImmutableMap.builder();
            return this.putAllToHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
            this.toHeaders.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cas(Optional<Long> cas) {
            this.cas = cas.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder acquire(String acquire) {
            this.acquire = Objects.requireNonNull(acquire, "acquire");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder acquire(Optional<String> acquire) {
            this.acquire = acquire.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder release(String release) {
            this.release = Objects.requireNonNull(release, "release");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder release(Optional<String> release) {
            this.release = release.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dc(String dc) {
            this.dc = Objects.requireNonNull(dc, "dc");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dc(Optional<String> dc) {
            this.dc = dc.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        public ImmutablePutOptions build() {
            return new ImmutablePutOptions(this.toHeaders.build(), this.cas, this.acquire, this.release, this.dc, this.token);
        }
    }
}

