/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Compression;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.utils.base64;
import java.io.IOException;

public class DHCIDRecord
extends Record {
    private byte[] data;

    DHCIDRecord() {
    }

    public DHCIDRecord(Name name, int dclass, long ttl, byte[] data) {
        super(name, 49, dclass, ttl);
        this.data = data;
    }

    @Override
    void rrFromWire(DNSInput in) {
        this.data = in.readByteArray();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.data = st.getBase64();
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }

    @Override
    String rrToString() {
        return base64.toString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }
}

