/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Client;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Message;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Type;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NioTcpClient
extends Client {
    private static final Logger log = LoggerFactory.getLogger(NioTcpClient.class);
    private static Queue<ChannelState> registrationQueue;
    private static Map<ChannelKey, ChannelState> channelMap;
    private static volatile boolean run;

    private static void startTcp() throws IOException {
        if (run) {
            return;
        }
        run = true;
        registrationQueue = new ConcurrentLinkedQueue<ChannelState>();
        channelMap = new ConcurrentHashMap<ChannelKey, ChannelState>();
        NioTcpClient.addSelectorTimeoutTask(NioTcpClient::processPendingRegistrations);
        NioTcpClient.addSelectorTimeoutTask(NioTcpClient::checkTransactionTimeouts);
        NioTcpClient.start();
    }

    private static void processPendingRegistrations() {
        while (!registrationQueue.isEmpty()) {
            ChannelState state = registrationQueue.remove();
            try {
                if (!state.channel.isConnected()) {
                    state.channel.register(selector, 8, state);
                    continue;
                }
                state.channel.keyFor(selector).interestOps(4);
            }
            catch (ClosedChannelException e) {
                state.handleChannelException(e);
            }
        }
    }

    private static void checkTransactionTimeouts() {
        for (ChannelState state : channelMap.values()) {
            Iterator it = state.pendingTransactions.iterator();
            while (it.hasNext()) {
                Transaction t = (Transaction)it.next();
                if (t.endTime - System.nanoTime() >= 0L) continue;
                t.f.completeExceptionally(new SocketTimeoutException("Query timed out"));
                it.remove();
            }
        }
    }

    static void closeTcp() throws Exception {
        if (!run) {
            return;
        }
        registrationQueue.clear();
        EOFException closing = new EOFException("Client is closing");
        channelMap.forEach((key, state) -> state.handleTransactionException(closing));
        channelMap.clear();
        NioTcpClient.close();
    }

    static CompletableFuture<byte[]> sendrecv(InetSocketAddress local, InetSocketAddress remote, Message query, byte[] data, Duration timeout) {
        CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        try {
            NioTcpClient.startTcp();
            long endTime = System.nanoTime() + timeout.toNanos();
            ChannelState channel = channelMap.computeIfAbsent(new ChannelKey(local, remote), key -> {
                try {
                    log.trace("Opening async channel for l={}/r={}", (Object)local, (Object)remote);
                    SocketChannel c = SocketChannel.open();
                    c.configureBlocking(false);
                    if (local != null) {
                        c.bind(local);
                    }
                    c.connect(remote);
                    return new ChannelState(c);
                }
                catch (IOException e) {
                    f.completeExceptionally(e);
                    return null;
                }
            });
            if (channel != null) {
                log.trace("Creating transaction for {}/{}", (Object)query.getQuestion().getName(), (Object)Type.string(query.getQuestion().getType()));
                Transaction t = new Transaction(query, data, endTime, channel.channel, f);
                channel.pendingTransactions.add(t);
                registrationQueue.add(channel);
                selector.wakeup();
            }
        }
        catch (IOException e) {
            f.completeExceptionally(e);
        }
        return f;
    }

    private NioTcpClient() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class ChannelKey {
        final InetSocketAddress local;
        final InetSocketAddress remote;

        public ChannelKey(InetSocketAddress local, InetSocketAddress remote) {
            this.local = local;
            this.remote = remote;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelKey)) {
                return false;
            }
            ChannelKey other = (ChannelKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InetSocketAddress this$local = this.local;
            InetSocketAddress other$local = other.local;
            if (this$local == null ? other$local != null : !((Object)this$local).equals(other$local)) {
                return false;
            }
            InetSocketAddress this$remote = this.remote;
            InetSocketAddress other$remote = other.remote;
            return !(this$remote == null ? other$remote != null : !((Object)this$remote).equals(other$remote));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InetSocketAddress $local = this.local;
            result = result * 59 + ($local == null ? 43 : ((Object)$local).hashCode());
            InetSocketAddress $remote = this.remote;
            result = result * 59 + ($remote == null ? 43 : ((Object)$remote).hashCode());
            return result;
        }
    }

    private static class ChannelState
    implements Client.KeyProcessor {
        final SocketChannel channel;
        final Queue<Transaction> pendingTransactions = new ConcurrentLinkedQueue<Transaction>();
        ByteBuffer responseLengthData = ByteBuffer.allocate(2);
        ByteBuffer responseData = ByteBuffer.allocate(65535);
        int readState = 0;

        @Override
        public void processReadyKey(SelectionKey key) {
            if (key.isValid()) {
                if (key.isConnectable()) {
                    this.processConnect(key);
                } else {
                    if (key.isWritable()) {
                        this.processWrite(key);
                    }
                    if (key.isReadable()) {
                        this.processRead();
                    }
                }
            }
        }

        void handleTransactionException(IOException e) {
            Iterator it = this.pendingTransactions.iterator();
            while (it.hasNext()) {
                Transaction t = (Transaction)it.next();
                t.f.completeExceptionally(e);
                it.remove();
            }
        }

        private void handleChannelException(IOException e) {
            this.handleTransactionException(e);
            for (Map.Entry entry : channelMap.entrySet()) {
                if (entry.getValue() != this) continue;
                channelMap.remove(entry.getKey());
                try {
                    this.channel.close();
                }
                catch (IOException ex) {
                    log.error("failed to close channel", (Throwable)ex);
                }
                return;
            }
        }

        private void processConnect(SelectionKey key) {
            try {
                this.channel.finishConnect();
                key.interestOps(4);
            }
            catch (IOException e) {
                this.handleChannelException(e);
            }
        }

        private void processRead() {
            try {
                int read;
                if (this.readState == 0) {
                    read = this.channel.read(this.responseLengthData);
                    if (read < 0) {
                        this.handleChannelException(new EOFException());
                        return;
                    }
                    if (this.responseLengthData.position() == 2) {
                        int length = ((this.responseLengthData.get(0) & 0xFF) << 8) + (this.responseLengthData.get(1) & 0xFF);
                        this.responseLengthData.flip();
                        this.responseData.limit(length);
                        this.readState = 1;
                    }
                }
                if ((read = this.channel.read(this.responseData)) < 0) {
                    this.handleChannelException(new EOFException());
                    return;
                }
                if (this.responseData.hasRemaining()) {
                    return;
                }
            }
            catch (IOException e) {
                this.handleChannelException(e);
                return;
            }
            this.readState = 0;
            this.responseData.flip();
            byte[] data = new byte[this.responseData.limit()];
            System.arraycopy(this.responseData.array(), this.responseData.arrayOffset(), data, 0, this.responseData.limit());
            Client.verboseLog("TCP read", this.channel.socket().getLocalSocketAddress(), this.channel.socket().getRemoteSocketAddress(), data);
            Iterator it = this.pendingTransactions.iterator();
            while (it.hasNext()) {
                int id = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
                Transaction t = (Transaction)it.next();
                int qid = t.query.getHeader().getID();
                if (id != qid) continue;
                t.f.complete(data);
                it.remove();
                return;
            }
        }

        private void processWrite(SelectionKey key) {
            Iterator it = this.pendingTransactions.iterator();
            while (it.hasNext()) {
                Transaction t = (Transaction)it.next();
                try {
                    t.send();
                }
                catch (IOException e) {
                    t.f.completeExceptionally(e);
                    it.remove();
                }
            }
            key.interestOps(1);
        }

        public ChannelState(SocketChannel channel) {
            this.channel = channel;
        }
    }

    private static class Transaction {
        private final Message query;
        private final byte[] queryData;
        private final long endTime;
        private final SocketChannel channel;
        private final CompletableFuture<byte[]> f;
        private boolean sendDone;

        void send() throws IOException {
            if (this.sendDone) {
                return;
            }
            Client.verboseLog("TCP write", this.channel.socket().getLocalSocketAddress(), this.channel.socket().getRemoteSocketAddress(), this.queryData);
            ByteBuffer buffer = ByteBuffer.allocate(this.queryData.length + 2);
            buffer.put((byte)(this.queryData.length >>> 8));
            buffer.put((byte)(this.queryData.length & 0xFF));
            buffer.put(this.queryData);
            buffer.flip();
            while (buffer.hasRemaining()) {
                long n = this.channel.write(buffer);
                if (n >= 0L) continue;
                throw new EOFException();
            }
            this.sendDone = true;
        }

        public Transaction(Message query, byte[] queryData, long endTime, SocketChannel channel, CompletableFuture<byte[]> f) {
            this.query = query;
            this.queryData = queryData;
            this.endTime = endTime;
            this.channel = channel;
            this.f = f;
        }
    }
}

