/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Compression;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;

public class RPRecord
extends Record {
    private Name mailbox;
    private Name textDomain;

    RPRecord() {
    }

    public RPRecord(Name name, int dclass, long ttl, Name mailbox, Name textDomain) {
        super(name, 17, dclass, ttl);
        this.mailbox = RPRecord.checkName("mailbox", mailbox);
        this.textDomain = RPRecord.checkName("textDomain", textDomain);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.mailbox = new Name(in);
        this.textDomain = new Name(in);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.mailbox = st.getName(origin);
        this.textDomain = st.getName(origin);
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mailbox);
        sb.append(" ");
        sb.append(this.textDomain);
        return sb.toString();
    }

    public Name getMailbox() {
        return this.mailbox;
    }

    public Name getTextDomain() {
        return this.textDomain;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.mailbox.toWire(out, null, canonical);
        this.textDomain.toWire(out, null, canonical);
    }
}

