/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Message;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Options;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.TSIGRecord;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.TextParseException;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.utils.base64;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSIG {
    private static final Logger log = LoggerFactory.getLogger(TSIG.class);
    public static final Name GSS_TSIG = Name.fromConstantString("gss-tsig.");
    public static final Name HMAC_MD5;
    @Deprecated
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA224;
    public static final Name HMAC_SHA256;
    public static final Name HMAC_SHA384;
    public static final Name HMAC_SHA512;
    private static Map<Name, String> algMap;
    public static final Duration FUDGE;
    private Name name;
    private Name alg;
    private Mac hmac;

    public static Name algorithmToName(String alg) {
        for (Map.Entry<Name, String> entry : algMap.entrySet()) {
            if (!alg.equalsIgnoreCase(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unknown algorithm");
    }

    public static String nameToAlgorithm(Name name) {
        String alg = algMap.get(name);
        if (alg != null) {
            return alg;
        }
        throw new IllegalArgumentException("Unknown algorithm");
    }

    private static boolean verify(Mac mac, byte[] signature) {
        return TSIG.verify(mac, signature, false);
    }

    private static boolean verify(Mac mac, byte[] signature, boolean truncation_ok) {
        byte[] expected = mac.doFinal();
        if (truncation_ok && signature.length < expected.length) {
            byte[] truncated = new byte[signature.length];
            System.arraycopy(expected, 0, truncated, 0, truncated.length);
            expected = truncated;
        }
        return Arrays.equals(signature, expected);
    }

    private void init_hmac(String macAlgorithm, SecretKey key) {
        try {
            this.hmac = Mac.getInstance(macAlgorithm);
            this.hmac.init(key);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Caught security exception setting up HMAC.");
        }
    }

    public TSIG(Name algorithm, Name name, byte[] keyBytes) {
        this.name = name;
        this.alg = algorithm;
        String macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        SecretKeySpec key = new SecretKeySpec(keyBytes, macAlgorithm);
        this.init_hmac(macAlgorithm, key);
    }

    public TSIG(Name algorithm, Name name, SecretKey key) {
        this.name = name;
        this.alg = algorithm;
        String macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        this.init_hmac(macAlgorithm, key);
    }

    public TSIG(Mac mac, Name name) {
        this.name = name;
        this.hmac = mac;
        this.alg = TSIG.algorithmToName(mac.getAlgorithm());
    }

    public TSIG(Name name, byte[] key) {
        this(HMAC_MD5, name, key);
    }

    public TSIG(Name algorithm, String name, String key) {
        byte[] keyBytes = base64.fromString(key);
        if (keyBytes == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString(name, Name.root);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = algorithm;
        String macAlgorithm = TSIG.nameToAlgorithm(this.alg);
        this.init_hmac(macAlgorithm, new SecretKeySpec(keyBytes, macAlgorithm));
    }

    public TSIG(String algorithm, String name, String key) {
        this(TSIG.algorithmToName(algorithm), name, key);
    }

    public TSIG(String name, String key) {
        this(HMAC_MD5, name, key);
    }

    public static TSIG fromString(String str) {
        String[] parts = str.split("[:/]", 3);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid TSIG key specification");
        }
        if (parts.length == 3) {
            try {
                return new TSIG(parts[0], parts[1], parts[2]);
            }
            catch (IllegalArgumentException e) {
                parts = str.split("[:/]", 2);
            }
        }
        return new TSIG(HMAC_MD5, parts[0], parts[1]);
    }

    public TSIGRecord generate(Message m3, byte[] b, int error, TSIGRecord old) {
        DNSOutput out;
        int fudgeOption;
        Instant timeSigned = error != 18 ? Instant.now() : old.getTimeSigned();
        boolean signing = false;
        if (error == 0 || error == 18) {
            signing = true;
            this.hmac.reset();
        }
        Duration fudge = (fudgeOption = Options.intValue("tsigfudge")) < 0 || fudgeOption > Short.MAX_VALUE ? FUDGE : Duration.ofSeconds(fudgeOption);
        if (old != null) {
            out = new DNSOutput();
            out.writeU16(old.getSignature().length);
            if (signing) {
                this.hmac.update(out.toByteArray());
                this.hmac.update(old.getSignature());
            }
        }
        if (signing) {
            this.hmac.update(b);
        }
        out = new DNSOutput();
        this.name.toWireCanonical(out);
        out.writeU16(255);
        out.writeU32(0L);
        this.alg.toWireCanonical(out);
        long time = timeSigned.getEpochSecond();
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16((int)fudge.getSeconds());
        out.writeU16(error);
        out.writeU16(0);
        if (signing) {
            this.hmac.update(out.toByteArray());
        }
        byte[] signature = signing ? this.hmac.doFinal() : new byte[]{};
        byte[] other = null;
        if (error == 18) {
            out = new DNSOutput();
            time = Instant.now().getEpochSecond();
            timeHigh = (int)(time >> 32);
            timeLow = time & 0xFFFFFFFFL;
            out.writeU16(timeHigh);
            out.writeU32(timeLow);
            other = out.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m3.getHeader().getID(), error, other);
    }

    public void apply(Message m3, int error, TSIGRecord old) {
        TSIGRecord r = this.generate(m3, m3.toWire(), error, old);
        m3.addRecord(r, 3);
        m3.tsigState = 3;
    }

    public void apply(Message m3, TSIGRecord old) {
        this.apply(m3, 0, old);
    }

    public void applyStream(Message m3, TSIGRecord old, boolean first) {
        if (first) {
            this.apply(m3, old);
            return;
        }
        Instant timeSigned = Instant.now();
        this.hmac.reset();
        int fudgeOption = Options.intValue("tsigfudge");
        Duration fudge = fudgeOption < 0 || fudgeOption > Short.MAX_VALUE ? FUDGE : Duration.ofSeconds(fudgeOption);
        DNSOutput out = new DNSOutput();
        out.writeU16(old.getSignature().length);
        this.hmac.update(out.toByteArray());
        this.hmac.update(old.getSignature());
        this.hmac.update(m3.toWire());
        out = new DNSOutput();
        long time = timeSigned.getEpochSecond();
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16((int)fudge.getSeconds());
        this.hmac.update(out.toByteArray());
        byte[] signature = this.hmac.doFinal();
        TSIGRecord r = new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m3.getHeader().getID(), 0, null);
        m3.addRecord(r, 3);
        m3.tsigState = 3;
    }

    @Deprecated
    public byte verify(Message m3, byte[] b, int length, TSIGRecord old) {
        return (byte)this.verify(m3, b, old);
    }

    public int verify(Message m3, byte[] b, TSIGRecord old) {
        m3.tsigState = 4;
        TSIGRecord tsig = m3.getTSIG();
        this.hmac.reset();
        if (tsig == null) {
            return 1;
        }
        if (!tsig.getName().equals(this.name) || !tsig.getAlgorithm().equals(this.alg)) {
            log.debug("BADKEY failure");
            return 17;
        }
        Duration delta = Duration.between(Instant.now(), tsig.getTimeSigned()).abs();
        if (delta.compareTo(tsig.getFudge()) > 0) {
            log.debug("BADTIME failure");
            return 18;
        }
        if (old != null && tsig.getError() != 17 && tsig.getError() != 16) {
            DNSOutput out = new DNSOutput();
            out.writeU16(old.getSignature().length);
            this.hmac.update(out.toByteArray());
            this.hmac.update(old.getSignature());
        }
        m3.getHeader().decCount(3);
        byte[] header = m3.getHeader().toWire();
        m3.getHeader().incCount(3);
        this.hmac.update(header);
        int len = m3.tsigstart - header.length;
        this.hmac.update(b, header.length, len);
        DNSOutput out = new DNSOutput();
        tsig.getName().toWireCanonical(out);
        out.writeU16(tsig.dclass);
        out.writeU32(tsig.ttl);
        tsig.getAlgorithm().toWireCanonical(out);
        long time = tsig.getTimeSigned().getEpochSecond();
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16((int)tsig.getFudge().getSeconds());
        out.writeU16(tsig.getError());
        if (tsig.getOther() != null) {
            out.writeU16(tsig.getOther().length);
            out.writeByteArray(tsig.getOther());
        } else {
            out.writeU16(0);
        }
        this.hmac.update(out.toByteArray());
        byte[] signature = tsig.getSignature();
        int digestLength = this.hmac.getMacLength();
        int minDigestLength = this.hmac.getAlgorithm().toLowerCase().contains("md5") ? 10 : digestLength / 2;
        if (signature.length > digestLength) {
            log.debug("BADSIG: signature too long");
            return 16;
        }
        if (signature.length < minDigestLength) {
            log.debug("BADSIG: signature too short");
            return 16;
        }
        if (!TSIG.verify(this.hmac, signature, true)) {
            log.debug("BADSIG: signature verification");
            return 16;
        }
        m3.tsigState = 1;
        return 0;
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString("HMAC-MD5.SIG-ALG.REG.INT.");
        HMAC_SHA1 = Name.fromConstantString("hmac-sha1.");
        HMAC_SHA224 = Name.fromConstantString("hmac-sha224.");
        HMAC_SHA256 = Name.fromConstantString("hmac-sha256.");
        HMAC_SHA384 = Name.fromConstantString("hmac-sha384.");
        HMAC_SHA512 = Name.fromConstantString("hmac-sha512.");
        HashMap<Name, String> out = new HashMap<Name, String>();
        out.put(HMAC_MD5, "HmacMD5");
        out.put(HMAC_SHA1, "HmacSHA1");
        out.put(HMAC_SHA224, "HmacSHA224");
        out.put(HMAC_SHA256, "HmacSHA256");
        out.put(HMAC_SHA384, "HmacSHA384");
        out.put(HMAC_SHA512, "HmacSHA512");
        algMap = Collections.unmodifiableMap(out);
        FUDGE = Duration.ofSeconds(300L);
    }

    public static class StreamVerifier {
        private TSIG key;
        private Mac verifier;
        private int nresponses;
        private int lastsigned;
        private TSIGRecord lastTSIG;

        public StreamVerifier(TSIG tsig, TSIGRecord old) {
            this.key = tsig;
            this.verifier = tsig.hmac;
            this.nresponses = 0;
            this.lastTSIG = old;
        }

        public int verify(Message m3, byte[] b) {
            TSIGRecord tsig = m3.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                int result = this.key.verify(m3, b, this.lastTSIG);
                if (result == 0) {
                    byte[] signature = tsig.getSignature();
                    DNSOutput out = new DNSOutput();
                    out.writeU16(signature.length);
                    this.verifier.update(out.toByteArray());
                    this.verifier.update(signature);
                }
                this.lastTSIG = tsig;
                return result;
            }
            if (tsig != null) {
                m3.getHeader().decCount(3);
            }
            byte[] header = m3.getHeader().toWire();
            if (tsig != null) {
                m3.getHeader().incCount(3);
            }
            this.verifier.update(header);
            int len = tsig == null ? b.length - header.length : m3.tsigstart - header.length;
            this.verifier.update(b, header.length, len);
            if (tsig == null) {
                boolean required;
                boolean bl = required = this.nresponses - this.lastsigned >= 100;
                if (required) {
                    m3.tsigState = 4;
                    return 1;
                }
                m3.tsigState = 2;
                return 0;
            }
            this.lastsigned = this.nresponses;
            this.lastTSIG = tsig;
            if (!tsig.getName().equals(this.key.name) || !tsig.getAlgorithm().equals(this.key.alg)) {
                log.debug("BADKEY failure");
                m3.tsigState = 4;
                return 17;
            }
            DNSOutput out = new DNSOutput();
            long time = tsig.getTimeSigned().getEpochSecond();
            int timeHigh = (int)(time >> 32);
            long timeLow = time & 0xFFFFFFFFL;
            out.writeU16(timeHigh);
            out.writeU32(timeLow);
            out.writeU16((int)tsig.getFudge().getSeconds());
            this.verifier.update(out.toByteArray());
            if (!TSIG.verify(this.verifier, tsig.getSignature())) {
                log.debug("BADSIG failure");
                m3.tsigState = 4;
                return 16;
            }
            this.verifier.reset();
            out = new DNSOutput();
            out.writeU16(tsig.getSignature().length);
            this.verifier.update(out.toByteArray());
            this.verifier.update(tsig.getSignature());
            m3.tsigState = 1;
            return 0;
        }
    }
}

