/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Compression;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.TextParseException;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;

public class URIRecord
extends Record {
    private int priority;
    private int weight;
    private byte[] target;

    URIRecord() {
        this.target = new byte[0];
    }

    public URIRecord(Name name, int dclass, long ttl, int priority, int weight, String target) {
        super(name, 256, dclass, ttl);
        this.priority = URIRecord.checkU16("priority", priority);
        this.weight = URIRecord.checkU16("weight", weight);
        try {
            this.target = URIRecord.byteArrayFromString(target);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.priority = in.readU16();
        this.weight = in.readU16();
        this.target = in.readByteArray();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.priority = st.getUInt16();
        this.weight = st.getUInt16();
        try {
            this.target = URIRecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.priority).append(" ");
        sb.append(this.weight).append(" ");
        sb.append(URIRecord.byteArrayToString(this.target, true));
        return sb.toString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getTarget() {
        return URIRecord.byteArrayToString(this.target, false);
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.priority);
        out.writeU16(this.weight);
        out.writeByteArray(this.target);
    }
}

