/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose.proc;

import io.hops.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.KeySourceException;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.JWK;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.JWKMatcher;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.JWKSelector;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.KeyType;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.KeyUse;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.source.JWKSource;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import io.hops.hadoop.shaded.com.nimbusds.jose.proc.AbstractJWKSelectorWithSource;
import io.hops.hadoop.shaded.com.nimbusds.jose.proc.JWSKeySelector;
import io.hops.hadoop.shaded.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import io.hops.hadoop.shaded.com.nimbusds.jose.proc.SecurityContext;
import java.net.URL;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JWSAlgorithmFamilyJWSKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWSKeySelector<C> {
    private final Map<JWSAlgorithm, JWSKeySelector<C>> selectors = new HashMap<JWSAlgorithm, JWSKeySelector<C>>();

    public JWSAlgorithmFamilyJWSKeySelector(JWSAlgorithm.Family jwsAlgFamily, JWKSource<C> jwkSource) {
        super(jwkSource);
        if (jwsAlgFamily == null) {
            throw new IllegalArgumentException("JWS algorithm family must not be null");
        }
        for (JWSAlgorithm jwsAlg : jwsAlgFamily) {
            this.selectors.put(jwsAlg, new JWSVerificationKeySelector<C>(jwsAlg, jwkSource));
        }
    }

    @Override
    public List<? extends Key> selectJWSKeys(JWSHeader header, C context) throws KeySourceException {
        JWSKeySelector<C> selector = this.selectors.get(header.getAlgorithm());
        if (selector == null) {
            return Collections.emptyList();
        }
        return selector.selectJWSKeys(header, context);
    }

    public static <C extends SecurityContext> JWSAlgorithmFamilyJWSKeySelector<C> fromJWKSetURL(URL jwkSetURL) throws KeySourceException {
        RemoteJWKSet jwkSource = new RemoteJWKSet(jwkSetURL);
        return JWSAlgorithmFamilyJWSKeySelector.fromJWKSource(jwkSource);
    }

    public static <C extends SecurityContext> JWSAlgorithmFamilyJWSKeySelector<C> fromJWKSource(JWKSource<C> jwkSource) throws KeySourceException {
        JWKMatcher jwkMatcher = new JWKMatcher.Builder().publicOnly(true).keyUses(KeyUse.SIGNATURE, null).keyTypes(KeyType.RSA, KeyType.EC).build();
        List<JWK> jwks = jwkSource.get(new JWKSelector(jwkMatcher), null);
        for (JWK jwk : jwks) {
            if (KeyType.RSA.equals(jwk.getKeyType())) {
                return new JWSAlgorithmFamilyJWSKeySelector<C>(JWSAlgorithm.Family.RSA, jwkSource);
            }
            if (!KeyType.EC.equals(jwk.getKeyType())) continue;
            return new JWSAlgorithmFamilyJWSKeySelector<C>(JWSAlgorithm.Family.EC, jwkSource);
        }
        throw new KeySourceException("Couldn't retrieve JWKs");
    }
}

