/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.container.servlet;

import io.hops.hadoop.shaded.com.sun.jersey.api.container.ContainerException;
import io.hops.hadoop.shaded.com.sun.jersey.api.core.HttpContext;
import io.hops.hadoop.shaded.com.sun.jersey.api.core.ResourceConfig;
import io.hops.hadoop.shaded.com.sun.jersey.api.view.Viewable;
import io.hops.hadoop.shaded.com.sun.jersey.core.reflection.ReflectionHelper;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.container.servlet.RequestDispatcherWrapper;
import io.hops.hadoop.shaded.com.sun.jersey.spi.template.ViewProcessor;
import io.hops.hadoop.shaded.javax.servlet.RequestDispatcher;
import io.hops.hadoop.shaded.javax.servlet.ServletContext;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.javax.ws.rs.core.Context;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class JSPTemplateProcessor
implements ViewProcessor<String> {
    @Context
    private HttpContext hc;
    @Context
    private ServletContext servletContext;
    @Context
    private ThreadLocal<HttpServletRequest> requestInvoker;
    @Context
    private ThreadLocal<HttpServletResponse> responseInvoker;
    private final String basePath;

    public JSPTemplateProcessor(@Context ResourceConfig resourceConfig) {
        String path = (String)resourceConfig.getProperties().get("io.hops.hadoop.shaded.com.sun.jersey.config.property.JSPTemplatesBasePath");
        this.basePath = path == null ? "" : (path.charAt(0) == '/' ? path : "/" + path);
    }

    public String resolve(String path) {
        if (this.servletContext == null) {
            return null;
        }
        if (this.basePath != "") {
            path = this.basePath + path;
        }
        try {
            if (this.servletContext.getResource(path) != null) {
                return path;
            }
            if (!path.endsWith(".jsp") && this.servletContext.getResource(path = path + ".jsp") != null) {
                return path;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public void writeTo(String resolvedPath, Viewable viewable, OutputStream out) throws IOException {
        if (this.hc.isTracingEnabled()) {
            this.hc.trace(String.format("forwarding view to JSP page: \"%s\", it = %s", resolvedPath, ReflectionHelper.objectToString(viewable.getModel())));
        }
        out.flush();
        RequestDispatcher d = this.servletContext.getRequestDispatcher(resolvedPath);
        if (d == null) {
            throw new ContainerException("No request dispatcher for: " + resolvedPath);
        }
        d = new RequestDispatcherWrapper(d, this.basePath, this.hc, viewable);
        try {
            d.forward(this.requestInvoker.get(), this.responseInvoker.get());
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
    }
}

