/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.common.entity;

import io.hops.hadoop.shaded.io.hops.metadata.common.entity.Variable;
import java.nio.ByteBuffer;
import java.util.Objects;

public class IntVariable
extends Variable {
    private Integer value = new Integer(0);

    public IntVariable(Variable.Finder type, int value) {
        this(type);
        this.value = value;
    }

    public IntVariable(Variable.Finder type) {
        super(type);
    }

    public IntVariable(int value) {
        this(Variable.Finder.GenericInteger, value);
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] val) {
        if (val == null || val.length != this.getLength()) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(val);
        this.value = buf.getInt();
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putInt(this.value);
        return buf.array();
    }

    @Override
    public int getLength() {
        return 4;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntVariable that = (IntVariable)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

