/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.election.entity;

import io.hops.hadoop.shaded.io.hops.metadata.common.FinderType;

public abstract class LeDescriptor
implements Comparable<LeDescriptor>,
Cloneable {
    public static final int DEFAULT_PARTITION_VALUE = 0;
    public static final byte DEFAULT_LOCATION_DOMAIN_ID = 0;
    private long id;
    private long counter;
    private String rpcAddresses;
    private String httpAddress;
    private final int partitionVal = 0;
    private byte locationDomainId;

    protected LeDescriptor() {
    }

    protected LeDescriptor(LeDescriptor descriptor) {
        this.id = descriptor.id;
        this.counter = descriptor.counter;
        this.rpcAddresses = descriptor.rpcAddresses;
        this.httpAddress = descriptor.httpAddress;
        this.locationDomainId = descriptor.locationDomainId;
    }

    protected LeDescriptor(long id, long counter, String rpcAddresses, String httpAddress, byte locationDomainId) {
        this.id = id;
        this.counter = counter;
        this.rpcAddresses = rpcAddresses;
        this.httpAddress = httpAddress;
        this.locationDomainId = locationDomainId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getCounter() {
        return this.counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public String getRpcAddresses() {
        return this.rpcAddresses;
    }

    public void setRpcAddresses(String rpcAddresses) {
        this.rpcAddresses = rpcAddresses;
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }

    public void setHttpAddress(String httpAddress) {
        this.httpAddress = httpAddress;
    }

    public int getPartitionVal() {
        return 0;
    }

    public byte getLocationDomainId() {
        return this.locationDomainId;
    }

    public void setLocationDomainId(byte locationDomainId) {
        this.locationDomainId = locationDomainId;
    }

    @Override
    public int compareTo(LeDescriptor l) {
        if (this.id < l.getId()) {
            return -1;
        }
        if (this.id == l.getId()) {
            return 0;
        }
        if (this.id > l.getId()) {
            return 1;
        }
        throw new IllegalStateException("Leader.java: compareTo(...) is confused.");
    }

    public boolean equals(Object obj) {
        if (obj instanceof LeDescriptor) {
            LeDescriptor l = (LeDescriptor)obj;
            return this.id == l.getId() && this.counter == l.getCounter() && this.rpcAddresses.equals(l.getRpcAddresses());
        }
        throw new ClassCastException("Leader.java: equals(...) can not compare the objects");
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.rpcAddresses.hashCode();
        hash = hash * 31 + new Long(this.id).hashCode();
        hash = hash * 31 + new Long(this.counter).hashCode();
        return hash;
    }

    public String toString() {
        return this.id + ", " + this.rpcAddresses + ", " + this.counter;
    }

    public static class FailedNodeLeDescriptor
    extends LeDescriptor {
        final long failTime = System.currentTimeMillis();

        public FailedNodeLeDescriptor(LeDescriptor descriptor) {
            super(descriptor);
        }

        public long getFailTime() {
            return this.failTime;
        }
    }

    public static class HdfsLeDescriptor
    extends LeDescriptor {
        public HdfsLeDescriptor(long id, long counter, String rpcAddresses, String httpAddress, byte locationDomainId) {
            super(id, counter, rpcAddresses, httpAddress, locationDomainId);
        }

        public static enum Finder implements LeDescriptorFinder<HdfsLeDescriptor>
        {
            ById,
            All;


            @Override
            public Class getType() {
                return HdfsLeDescriptor.class;
            }

            @Override
            public FinderType.Annotation getAnnotated() {
                switch (this) {
                    case ById: {
                        return FinderType.Annotation.PrimaryKey;
                    }
                    case All: {
                        return FinderType.Annotation.FullTable;
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    public static class YarnLeDescriptor
    extends LeDescriptor {
        public YarnLeDescriptor(long id, long counter, String hostName, String httpAddress, byte locationDomainId) {
            super(id, counter, hostName, httpAddress, locationDomainId);
        }

        public static enum Finder implements LeDescriptorFinder<YarnLeDescriptor>
        {
            ById,
            All;


            @Override
            public Class getType() {
                return YarnLeDescriptor.class;
            }

            @Override
            public FinderType.Annotation getAnnotated() {
                switch (this) {
                    case ById: {
                        return FinderType.Annotation.PrimaryKey;
                    }
                    case All: {
                        return FinderType.Annotation.FullTable;
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    public static interface LeDescriptorFinder<T extends LeDescriptor>
    extends FinderType {
    }
}

