/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity;

import io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity.Replica;
import java.util.Objects;

public abstract class ReplicaBase
implements Comparable<ReplicaBase> {
    protected int storageId;
    protected long blockId;
    protected long inodeId;

    public ReplicaBase(int storageId, long blockId, long inodeId) {
        this.storageId = storageId;
        this.blockId = blockId;
        this.inodeId = inodeId;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public void setStorageId(int storageId) {
        this.storageId = storageId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(long blockId) {
        this.blockId = blockId;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(int inodeId) {
        this.inodeId = inodeId;
    }

    public int hashCode() {
        return Objects.hash(this.storageId, this.inodeId, this.blockId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Replica replica = (Replica)o;
        return this.storageId == replica.storageId && this.blockId == replica.blockId;
    }

    @Override
    public int compareTo(ReplicaBase t) {
        if (t == null) {
            return 1;
        }
        int compVal = new Integer(this.storageId).compareTo(t.storageId);
        if (compVal != 0) {
            return compVal;
        }
        compVal = new Long(this.inodeId).compareTo(t.inodeId);
        if (compVal != 0) {
            return compVal;
        }
        compVal = new Long(this.blockId).compareTo(t.blockId);
        if (compVal != 0) {
            return compVal;
        }
        return 0;
    }

    public String toString() {
        return "ReplicaBase{storageId=" + this.storageId + ", blockId=" + this.blockId + ", inodeId=" + this.inodeId + '}';
    }
}

