/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.math3.stat.inference;

import io.hops.hadoop.shaded.org.apache.commons.math3.distribution.FDistribution;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.ConvergenceException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NullArgumentException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.util.Localizable;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import io.hops.hadoop.shaded.org.apache.commons.math3.stat.descriptive.summary.Sum;
import io.hops.hadoop.shaded.org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneWayAnova {
    public double anovaFValue(Collection<double[]> categoryData) throws NullArgumentException, DimensionMismatchException {
        AnovaStats a = this.anovaStats(categoryData);
        return a.F;
    }

    public double anovaPValue(Collection<double[]> categoryData) throws NullArgumentException, DimensionMismatchException, ConvergenceException, MaxCountExceededException {
        AnovaStats a = this.anovaStats(categoryData);
        FDistribution fdist = new FDistribution(a.dfbg, a.dfwg);
        return 1.0 - fdist.cumulativeProbability(a.F);
    }

    public boolean anovaTest(Collection<double[]> categoryData, double alpha) throws NullArgumentException, DimensionMismatchException, OutOfRangeException, ConvergenceException, MaxCountExceededException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)alpha, 0, 0.5);
        }
        return this.anovaPValue(categoryData) < alpha;
    }

    private AnovaStats anovaStats(Collection<double[]> categoryData) throws NullArgumentException, DimensionMismatchException {
        if (categoryData == null) {
            throw new NullArgumentException();
        }
        if (categoryData.size() < 2) {
            throw new DimensionMismatchException((Localizable)LocalizedFormats.TWO_OR_MORE_CATEGORIES_REQUIRED, categoryData.size(), 2);
        }
        for (double[] array : categoryData) {
            if (array.length > 1) continue;
            throw new DimensionMismatchException((Localizable)LocalizedFormats.TWO_OR_MORE_VALUES_IN_CATEGORY_REQUIRED, array.length, 2);
        }
        int dfwg = 0;
        double sswg = 0.0;
        Sum totsum = new Sum();
        SumOfSquares totsumsq = new SumOfSquares();
        int totnum = 0;
        for (double[] data : categoryData) {
            Sum sum = new Sum();
            SumOfSquares sumsq = new SumOfSquares();
            int num = 0;
            for (int i = 0; i < data.length; ++i) {
                double val = data[i];
                ++num;
                sum.increment(val);
                sumsq.increment(val);
                ++totnum;
                totsum.increment(val);
                totsumsq.increment(val);
            }
            dfwg += num - 1;
            double ss = sumsq.getResult() - sum.getResult() * sum.getResult() / (double)num;
            sswg += ss;
        }
        double sst = totsumsq.getResult() - totsum.getResult() * totsum.getResult() / (double)totnum;
        double ssbg = sst - sswg;
        int dfbg = categoryData.size() - 1;
        double msbg = ssbg / (double)dfbg;
        double mswg = sswg / (double)dfwg;
        double F = msbg / mswg;
        return new AnovaStats(dfbg, dfwg, F);
    }

    private static class AnovaStats {
        private final int dfbg;
        private final int dfwg;
        private final double F;

        private AnovaStats(int dfbg, int dfwg, double F) {
            this.dfbg = dfbg;
            this.dfwg = dfwg;
            this.F = F;
        }
    }
}

