/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.net.imap;

import io.hops.hadoop.shaded.org.apache.commons.net.SocketClient;
import io.hops.hadoop.shaded.org.apache.commons.net.imap.IMAPCommand;
import io.hops.hadoop.shaded.org.apache.commons.net.imap.IMAPReply;
import io.hops.hadoop.shaded.org.apache.commons.net.io.CRLFLineReader;
import io.hops.hadoop.shaded.org.apache.commons.net.util.NetConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class IMAP
extends SocketClient {
    public static final int DEFAULT_PORT = 143;
    protected static final String __DEFAULT_ENCODING = "ISO-8859-1";
    public static final IMAPChunkListener TRUE_CHUNK_LISTENER = imap -> true;
    private IMAPState state;
    protected BufferedWriter __writer;
    protected BufferedReader _reader;
    private int replyCode;
    private final List<String> replyLines;
    private volatile IMAPChunkListener chunkListener;
    private final char[] initialID = new char[]{'A', 'A', 'A', 'A'};

    static String quoteMailboxName(String input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return "\"\"";
        }
        if (input.length() > 1 && input.startsWith("\"") && input.endsWith("\"")) {
            return input;
        }
        if (input.contains(" ")) {
            return "\"" + input.replaceAll("([\\\\\"])", "\\\\$1") + "\"";
        }
        return input;
    }

    public IMAP() {
        this.setDefaultPort(143);
        this.state = IMAPState.DISCONNECTED_STATE;
        this._reader = null;
        this.__writer = null;
        this.replyLines = new ArrayList<String>();
        this.createCommandSupport();
    }

    @Override
    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this._reader = new CRLFLineReader(new InputStreamReader(this._input_, __DEFAULT_ENCODING));
        this.__writer = new BufferedWriter(new OutputStreamWriter(this._output_, __DEFAULT_ENCODING));
        int tmo = this.getSoTimeout();
        if (tmo <= 0) {
            this.setSoTimeout(this.connectTimeout);
        }
        this.getReply(false);
        if (tmo <= 0) {
            this.setSoTimeout(tmo);
        }
        this.setState(IMAPState.NOT_AUTH_STATE);
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this._reader = null;
        this.__writer = null;
        this.replyLines.clear();
        this.setState(IMAPState.DISCONNECTED_STATE);
    }

    public boolean doCommand(IMAPCommand command) throws IOException {
        return IMAPReply.isSuccess(this.sendCommand(command));
    }

    public boolean doCommand(IMAPCommand command, String args) throws IOException {
        return IMAPReply.isSuccess(this.sendCommand(command, args));
    }

    @Override
    protected void fireReplyReceived(int replyCode, String ignored) {
        if (this.getCommandSupport().getListenerCount() > 0) {
            this.getCommandSupport().fireReplyReceived(replyCode, this.getReplyString());
        }
    }

    protected String generateCommandID() {
        String res = new String(this.initialID);
        boolean carry = true;
        for (int i = this.initialID.length - 1; carry && i >= 0; --i) {
            if (this.initialID[i] == 'Z') {
                this.initialID[i] = 65;
                continue;
            }
            int n = i;
            this.initialID[n] = (char)(this.initialID[n] + '\u0001');
            carry = false;
        }
        return res;
    }

    private void getReply() throws IOException {
        this.getReply(true);
    }

    private void getReply(boolean wantTag) throws IOException {
        this.replyLines.clear();
        String line = this._reader.readLine();
        if (line == null) {
            throw new EOFException("Connection closed without indication.");
        }
        this.replyLines.add(line);
        if (wantTag) {
            while (IMAPReply.isUntagged(line)) {
                boolean clear;
                IMAPChunkListener il;
                boolean isMultiLine;
                int literalCount = IMAPReply.literalCount(line);
                boolean bl = isMultiLine = literalCount >= 0;
                while (literalCount >= 0) {
                    line = this._reader.readLine();
                    if (line == null) {
                        throw new EOFException("Connection closed without indication.");
                    }
                    this.replyLines.add(line);
                    literalCount -= line.length() + 2;
                }
                if (isMultiLine && (il = this.chunkListener) != null && (clear = il.chunkReceived(this))) {
                    this.fireReplyReceived(3, this.getReplyString());
                    this.replyLines.clear();
                }
                if ((line = this._reader.readLine()) == null) {
                    throw new EOFException("Connection closed without indication.");
                }
                this.replyLines.add(line);
            }
            this.replyCode = IMAPReply.getReplyCode(line);
        } else {
            this.replyCode = IMAPReply.getUntaggedReplyCode(line);
        }
        this.fireReplyReceived(this.replyCode, this.getReplyString());
    }

    public String getReplyString() {
        StringBuilder buffer = new StringBuilder(256);
        for (String s2 : this.replyLines) {
            buffer.append(s2);
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    public String[] getReplyStrings() {
        return this.replyLines.toArray(NetConstants.EMPTY_STRING_ARRAY);
    }

    public IMAPState getState() {
        return this.state;
    }

    public int sendCommand(IMAPCommand command) throws IOException {
        return this.sendCommand(command, null);
    }

    public int sendCommand(IMAPCommand command, String args) throws IOException {
        return this.sendCommand(command.getIMAPCommand(), args);
    }

    public int sendCommand(String command) throws IOException {
        return this.sendCommand(command, null);
    }

    public int sendCommand(String command, String args) throws IOException {
        return this.sendCommandWithID(this.generateCommandID(), command, args);
    }

    private int sendCommandWithID(String commandID, String command, String args) throws IOException {
        StringBuilder __commandBuffer = new StringBuilder();
        if (commandID != null) {
            __commandBuffer.append(commandID);
            __commandBuffer.append(' ');
        }
        __commandBuffer.append(command);
        if (args != null) {
            __commandBuffer.append(' ');
            __commandBuffer.append(args);
        }
        __commandBuffer.append("\r\n");
        String message = __commandBuffer.toString();
        this.__writer.write(message);
        this.__writer.flush();
        this.fireCommandSent(command, message);
        this.getReply();
        return this.replyCode;
    }

    public int sendData(String command) throws IOException {
        return this.sendCommandWithID(null, command, null);
    }

    public void setChunkListener(IMAPChunkListener listener) {
        this.chunkListener = listener;
    }

    protected void setState(IMAPState state) {
        this.state = state;
    }

    public static enum IMAPState {
        DISCONNECTED_STATE,
        NOT_AUTH_STATE,
        AUTH_STATE,
        LOGOUT_STATE;

    }

    public static interface IMAPChunkListener {
        public boolean chunkReceived(IMAP var1);
    }
}

