/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.net.nntp;

import io.hops.hadoop.shaded.org.apache.commons.net.MalformedServerReplyException;
import io.hops.hadoop.shaded.org.apache.commons.net.ProtocolCommandSupport;
import io.hops.hadoop.shaded.org.apache.commons.net.SocketClient;
import io.hops.hadoop.shaded.org.apache.commons.net.io.CRLFLineReader;
import io.hops.hadoop.shaded.org.apache.commons.net.nntp.NNTPCommand;
import io.hops.hadoop.shaded.org.apache.commons.net.nntp.NNTPConnectionClosedException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class NNTP
extends SocketClient {
    public static final int DEFAULT_PORT = 119;
    private static final Charset DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
    boolean _isAllowedToPost;
    private int replyCode;
    private String replyString;
    protected BufferedReader _reader_;
    protected BufferedWriter _writer_;
    protected ProtocolCommandSupport _commandSupport_;

    public NNTP() {
        this.setDefaultPort(119);
        this.replyString = null;
        this._reader_ = null;
        this._writer_ = null;
        this._isAllowedToPost = false;
        this._commandSupport_ = new ProtocolCommandSupport(this);
    }

    @Override
    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this._reader_ = new CRLFLineReader(new InputStreamReader(this._input_, DEFAULT_ENCODING));
        this._writer_ = new BufferedWriter(new OutputStreamWriter(this._output_, DEFAULT_ENCODING));
        this.getReply();
        this._isAllowedToPost = this.replyCode == 200;
    }

    public int article() throws IOException {
        return this.sendCommand(0);
    }

    @Deprecated
    public int article(int a) throws IOException {
        return this.article((long)a);
    }

    public int article(long articleNumber) throws IOException {
        return this.sendCommand(0, Long.toString(articleNumber));
    }

    public int article(String messageId) throws IOException {
        return this.sendCommand(0, messageId);
    }

    public int authinfoPass(String password) throws IOException {
        String passParameter = "PASS " + password;
        return this.sendCommand(15, passParameter);
    }

    public int authinfoUser(String username) throws IOException {
        String userParameter = "USER " + username;
        return this.sendCommand(15, userParameter);
    }

    public int body() throws IOException {
        return this.sendCommand(1);
    }

    @Deprecated
    public int body(int a) throws IOException {
        return this.body((long)a);
    }

    public int body(long articleNumber) throws IOException {
        return this.sendCommand(1, Long.toString(articleNumber));
    }

    public int body(String messageId) throws IOException {
        return this.sendCommand(1, messageId);
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this._reader_ = null;
        this._writer_ = null;
        this.replyString = null;
        this._isAllowedToPost = false;
    }

    @Override
    protected ProtocolCommandSupport getCommandSupport() {
        return this._commandSupport_;
    }

    public int getReply() throws IOException {
        this.replyString = this._reader_.readLine();
        if (this.replyString == null) {
            throw new NNTPConnectionClosedException("Connection closed without indication.");
        }
        if (this.replyString.length() < 3) {
            throw new MalformedServerReplyException("Truncated server reply: " + this.replyString);
        }
        try {
            this.replyCode = Integer.parseInt(this.replyString.substring(0, 3));
        }
        catch (NumberFormatException e) {
            throw new MalformedServerReplyException("Could not parse response code.\nServer Reply: " + this.replyString);
        }
        this.fireReplyReceived(this.replyCode, this.replyString + "\r\n");
        if (this.replyCode == 400) {
            throw new NNTPConnectionClosedException("NNTP response 400 received.  Server closed connection.");
        }
        return this.replyCode;
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public String getReplyString() {
        return this.replyString;
    }

    public int group(String newsgroup) throws IOException {
        return this.sendCommand(2, newsgroup);
    }

    public int head() throws IOException {
        return this.sendCommand(3);
    }

    @Deprecated
    public int head(int a) throws IOException {
        return this.head((long)a);
    }

    public int head(long articleNumber) throws IOException {
        return this.sendCommand(3, Long.toString(articleNumber));
    }

    public int head(String messageId) throws IOException {
        return this.sendCommand(3, messageId);
    }

    public int help() throws IOException {
        return this.sendCommand(4);
    }

    public int ihave(String messageId) throws IOException {
        return this.sendCommand(5, messageId);
    }

    public boolean isAllowedToPost() {
        return this._isAllowedToPost;
    }

    public int last() throws IOException {
        return this.sendCommand(6);
    }

    public int list() throws IOException {
        return this.sendCommand(7);
    }

    public int listActive(String wildmat) throws IOException {
        StringBuilder command = new StringBuilder("ACTIVE ");
        command.append(wildmat);
        return this.sendCommand(7, command.toString());
    }

    public int newgroups(String date, String time, boolean GMT, String distributions) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(date);
        buffer.append(' ');
        buffer.append(time);
        if (GMT) {
            buffer.append(' ');
            buffer.append("GMT");
        }
        if (distributions != null) {
            buffer.append(" <");
            buffer.append(distributions);
            buffer.append('>');
        }
        return this.sendCommand(8, buffer.toString());
    }

    public int newnews(String newsgroups, String date, String time, boolean GMT, String distributions) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(newsgroups);
        buffer.append(' ');
        buffer.append(date);
        buffer.append(' ');
        buffer.append(time);
        if (GMT) {
            buffer.append(' ');
            buffer.append("GMT");
        }
        if (distributions != null) {
            buffer.append(" <");
            buffer.append(distributions);
            buffer.append('>');
        }
        return this.sendCommand(9, buffer.toString());
    }

    public int next() throws IOException {
        return this.sendCommand(10);
    }

    public int post() throws IOException {
        return this.sendCommand(11);
    }

    public int quit() throws IOException {
        return this.sendCommand(12);
    }

    public int sendCommand(int command) throws IOException {
        return this.sendCommand(command, null);
    }

    public int sendCommand(int command, String args) throws IOException {
        return this.sendCommand(NNTPCommand.getCommand(command), args);
    }

    public int sendCommand(String command) throws IOException {
        return this.sendCommand(command, null);
    }

    public int sendCommand(String command, String args) throws IOException {
        StringBuilder __commandBuffer = new StringBuilder();
        __commandBuffer.append(command);
        if (args != null) {
            __commandBuffer.append(' ');
            __commandBuffer.append(args);
        }
        __commandBuffer.append("\r\n");
        String message = __commandBuffer.toString();
        this._writer_.write(message);
        this._writer_.flush();
        this.fireCommandSent(command, message);
        return this.getReply();
    }

    public int stat() throws IOException {
        return this.sendCommand(14);
    }

    @Deprecated
    public int stat(int a) throws IOException {
        return this.stat((long)a);
    }

    public int stat(long articleNumber) throws IOException {
        return this.sendCommand(14, Long.toString(articleNumber));
    }

    public int stat(String messageId) throws IOException {
        return this.sendCommand(14, messageId);
    }

    public int xhdr(String header, String selectedArticles) throws IOException {
        StringBuilder command = new StringBuilder(header);
        command.append(" ");
        command.append(selectedArticles);
        return this.sendCommand(17, command.toString());
    }

    public int xover(String selectedArticles) throws IOException {
        return this.sendCommand(16, selectedArticles);
    }
}

