/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.net.tftp;

import io.hops.hadoop.shaded.org.apache.commons.net.tftp.TFTPPacket;
import io.hops.hadoop.shaded.org.apache.commons.net.tftp.TFTPPacketException;
import java.net.DatagramPacket;
import java.net.InetAddress;

public final class TFTPAckPacket
extends TFTPPacket {
    int blockNumber;

    TFTPAckPacket(DatagramPacket datagram) throws TFTPPacketException {
        super(4, datagram.getAddress(), datagram.getPort());
        byte[] data = datagram.getData();
        if (this.getType() != data[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        this.blockNumber = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public TFTPAckPacket(InetAddress destination, int port, int blockNumber) {
        super(4, destination, port);
        this.blockNumber = blockNumber;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    @Override
    public DatagramPacket newDatagram() {
        byte[] data = new byte[]{0, (byte)this.type, (byte)((this.blockNumber & 0xFFFF) >> 8), (byte)(this.blockNumber & 0xFF)};
        return new DatagramPacket(data, data.length, this.address, this.port);
    }

    @Override
    DatagramPacket newDatagram(DatagramPacket datagram, byte[] data) {
        data[0] = 0;
        data[1] = (byte)this.type;
        data[2] = (byte)((this.blockNumber & 0xFFFF) >> 8);
        data[3] = (byte)(this.blockNumber & 0xFF);
        datagram.setAddress(this.address);
        datagram.setPort(this.port);
        datagram.setData(data);
        datagram.setLength(4);
        return datagram;
    }

    public void setBlockNumber(int blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public String toString() {
        return super.toString() + " ACK " + this.blockNumber;
    }
}

