/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.asn1;

public enum TagClass {
    UNKNOWN(-1),
    UNIVERSAL(0),
    APPLICATION(64),
    CONTEXT_SPECIFIC(128),
    PRIVATE(192);

    private int value;

    private TagClass(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isUniversal() {
        return this == UNIVERSAL;
    }

    public boolean isAppSpecific() {
        return this == APPLICATION;
    }

    public boolean isContextSpecific() {
        return this == CONTEXT_SPECIFIC;
    }

    public boolean isSpecific() {
        return this == APPLICATION || this == CONTEXT_SPECIFIC;
    }

    public static TagClass fromValue(int value) {
        switch (value) {
            case 0: {
                return UNIVERSAL;
            }
            case 64: {
                return APPLICATION;
            }
            case 128: {
                return CONTEXT_SPECIFIC;
            }
            case 192: {
                return PRIVATE;
            }
        }
        return UNKNOWN;
    }

    public static TagClass fromTag(int tag) {
        return TagClass.fromValue(tag & 0xC0);
    }
}

